/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class CertID {
    private static final String PREFIX_CN = "CN=";
    private final byte[] digest;
    private final String digestAlgorithmURI;
    private final X500Principal issuer;
    private final String issuerName;
    private final BigInteger serialNumber;

    private static void checkConstructorBaseArguments(String digestAlgorithmURI, byte[] digest, BigInteger serialNumber) {
        CertID.checkConstructorDigestAlgorithmArgument(digestAlgorithmURI);
        if (digest == null || digest.length == 0) {
            throw new IllegalArgumentException("digest required");
        }
        CertID.checkGetSerial(serialNumber);
    }

    private static X500Principal checkConstructorCertificateArgument(X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate required");
        }
        X500Principal tmp = certificate.getIssuerX500Principal();
        if (tmp == null) {
            throw new IllegalArgumentException("certificate with issuer principal required");
        }
        return tmp;
    }

    private static void checkConstructorDigestAlgorithmArgument(String digestAlgorithmURI) {
        if (digestAlgorithmURI == null || digestAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("digest algorithm required");
        }
        String jceDigestAlgorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(digestAlgorithmURI);
        if (jceDigestAlgorithm == null) {
            throw new IllegalArgumentException("digest algorithm not mappable to a JCE algorithm: " + digestAlgorithmURI);
        }
    }

    private static String checkGetIssuerName(String issuerName) {
        return CertID.checkGetIssuerName(new X500Principal(issuerName));
    }

    private static String checkGetIssuerName(X500Principal issuer) {
        String s = CertID.checkIssuer(issuer);
        return s.substring(PREFIX_CN.length());
    }

    private static BigInteger checkGetSerial(BigInteger serialNumber) {
        if (serialNumber == null) {
            throw new IllegalArgumentException("serial number is required");
        }
        return serialNumber;
    }

    private static String checkIssuer(X500Principal issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("issuer required");
        }
        String s = issuer.getName("RFC2253");
        if (s.isEmpty() || !s.contains(PREFIX_CN)) {
            throw new IllegalArgumentException("issuer principal does not contain a required common name value");
        }
        return s;
    }

    public CertID(String digestAlgorithmURI, byte[] digest, String issuerName, BigInteger serialNumber) {
        CertID.checkConstructorBaseArguments(digestAlgorithmURI, digest, serialNumber);
        if (issuerName == null || issuerName.isEmpty()) {
            throw new IllegalArgumentException("issuer name required");
        }
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.digest = digest;
        this.issuer = new X500Principal(issuerName);
        this.issuerName = issuerName;
        this.serialNumber = CertID.checkGetSerial(serialNumber);
    }

    public CertID(String digestAlgorithmURI, byte[] digest, X500Principal issuer, BigInteger serialNumber) {
        CertID.checkConstructorBaseArguments(digestAlgorithmURI, digest, serialNumber);
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.digest = digest;
        this.issuer = issuer;
        this.issuerName = CertID.checkGetIssuerName(issuer);
        this.serialNumber = CertID.checkGetSerial(serialNumber);
    }

    public CertID(String digestAlgorithmURI, X509Certificate certificate) {
        CertID.checkConstructorDigestAlgorithmArgument(digestAlgorithmURI);
        X500Principal tmp = CertID.checkConstructorCertificateArgument(certificate);
        this.digest = this.getDigest(digestAlgorithmURI, certificate);
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.serialNumber = CertID.checkGetSerial(certificate.getSerialNumber());
        this.issuerName = CertID.checkGetIssuerName(tmp);
        this.issuer = tmp;
    }

    public CertID(String digestAlgorithmURI, X509Certificate certificate, String issuerName) {
        CertID.checkConstructorDigestAlgorithmArgument(digestAlgorithmURI);
        X500Principal tmp = CertID.checkConstructorCertificateArgument(certificate);
        this.digest = this.getDigest(digestAlgorithmURI, certificate);
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.serialNumber = CertID.checkGetSerial(certificate.getSerialNumber());
        this.issuer = tmp;
        this.issuerName = issuerName == null || issuerName.isEmpty() ? CertID.checkGetIssuerName(tmp) : CertID.checkGetIssuerName(issuerName);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    private byte[] getDigest(String digestAlgorithmURI, X509Certificate certificate) {
        try {
            String jceDigestAlgorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(digestAlgorithmURI);
            MessageDigest md = MessageDigest.getInstance(jceDigestAlgorithm);
            return md.digest(certificate.getEncoded());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to calculate digest of certificate (" + digestAlgorithmURI + "): " + e.getMessage(), e);
        }
    }

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }
}

