/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignedProperty;
import de.governikus.csl.uom.sign.props.PropertyConstants;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.w3c.dom.Node;

public class AnySignedProperty<A>
extends AbstractSignedProperty {
    protected static final List<String> DEFAULT_OIDS = Collections.singletonList(PKCSObjectIdentifiers.pkcs_9_at_signingTime.getId());
    protected static final List<QName> DEFAULT_NODENAMES = PropertyConstants.XML_EMPTY_NODENAMES;
    private static final String XML_BASE_BEGIN = "<";
    public static final String XML_PREAMBLE_BEGIN = "<?xml ";
    public static final String XML_ENCODING_BEGIN = " encoding=\"";
    public static final String XML_ENCODING_UTF_8 = " encoding=\"UTF-8\"?>";
    private final A any;
    private final Node anyNode;

    public AnySignedProperty(Node node) {
        this(node, true, new ConstraintSignPolicy.EncodingConstraint[0]);
    }

    public AnySignedProperty(Node node, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(node, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public AnySignedProperty(Node node, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        if (node == null) {
            throw new IllegalArgumentException("node can not be null");
        }
        this.anyNode = node;
        String tmp = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            TransformerFactory tf = TransformerFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tf);
            Transformer t = tf.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(baos));
            tmp = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.any = tmp;
    }

    public AnySignedProperty(Node any, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(any, true, encodings == null ? null : Arrays.asList(encodings));
    }

    public AnySignedProperty(Node any, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(any, true, encodings == null ? null : encodings);
    }

    public AnySignedProperty(A any) {
        this(any, true, new ConstraintSignPolicy.EncodingConstraint[0]);
    }

    public AnySignedProperty(A any, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(any, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public AnySignedProperty(A any, boolean useDefaultEncodingVersion, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncodingVersion, encodings == null ? null : encodings);
        if (any == null) {
            throw new IllegalArgumentException("any can not be null");
        }
        this.any = any;
        Node tmp = null;
        if (any instanceof Node) {
            tmp = (Node)any;
        } else if (any instanceof String) {
            String sany = (String)any;
            if (AnySignedProperty.simpleXMLUTF8Check(sany)) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    tmp = db.parse(new ByteArrayInputStream(sany.getBytes(StandardCharsets.UTF_8))).getDocumentElement();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("not supported type of String, must represent a XML node, parsing String as XML failed!", e);
                }
            }
        } else if (!(any instanceof Calendar)) {
            throw new IllegalArgumentException("not supported type, Node or String only supported currently. used type: " + any.getClass());
        }
        this.anyNode = tmp;
    }

    public static boolean simpleXMLUTF8Check(String xmlUTF8Candidate) {
        if (xmlUTF8Candidate == null) {
            return false;
        }
        if (!xmlUTF8Candidate.startsWith(XML_BASE_BEGIN)) {
            return false;
        }
        if (xmlUTF8Candidate.startsWith(XML_PREAMBLE_BEGIN)) {
            return !xmlUTF8Candidate.contains(XML_ENCODING_BEGIN) || xmlUTF8Candidate.contains(XML_ENCODING_UTF_8);
        }
        return true;
    }

    public AnySignedProperty(A any, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(any, true, encodings == null ? null : Arrays.asList(encodings));
    }

    public AnySignedProperty(A any, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(any, true, encodings == null ? null : encodings);
    }

    public A getAny() {
        return this.any;
    }

    public Node getAnyNode() {
        return this.anyNode;
    }

    @Override
    public List<String> getOIDs() {
        return DEFAULT_OIDS;
    }

    @Override
    public List<QName> getNodeNames() {
        return DEFAULT_NODENAMES;
    }
}

