/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.EncodingHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractEncodingHolder
implements EncodingHolder {
    private final List<ConstraintSignPolicy.EncodingConstraint> encodings;

    public AbstractEncodingHolder() {
        this(ConstraintSignPolicy.EncodingConstraint.DEFAULT);
    }

    public AbstractEncodingHolder(ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(true, encodings == null ? null : Arrays.asList(encodings));
    }

    public AbstractEncodingHolder(boolean useDefaultVersion, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(useDefaultVersion, encodings == null ? null : Arrays.asList(encodings));
    }

    public AbstractEncodingHolder(List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(true, encodings);
    }

    public AbstractEncodingHolder(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        List<ConstraintSignPolicy.EncodingConstraint> tmp;
        this.encodings = ConstraintSignPolicy.EncodingConstraint.DEFAULT == encodings ? encodings : (useDefaultEncoding && (encodings == null || encodings.isEmpty()) ? ConstraintSignPolicy.EncodingConstraint.DEFAULT : ((tmp = this.createClone(useDefaultEncoding, encodings)) == ConstraintSignPolicy.EncodingConstraint.DEFAULT ? tmp : Collections.unmodifiableList(tmp)));
    }

    private List<ConstraintSignPolicy.EncodingConstraint> createClone(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        ArrayList<ConstraintSignPolicy.EncodingConstraint> tmp;
        List<Object> list = tmp = encodings == null ? new ArrayList() : new ArrayList<ConstraintSignPolicy.EncodingConstraint>(encodings);
        while (tmp.contains(null)) {
            tmp.remove(null);
        }
        while (tmp.contains((Object)ConstraintSignPolicy.EncodingConstraint.SPEC)) {
            tmp.remove((Object)ConstraintSignPolicy.EncodingConstraint.SPEC);
        }
        if (tmp.isEmpty() && useDefaultEncoding) {
            tmp = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
        }
        if (useDefaultEncoding && !tmp.containsAll(ConstraintSignPolicy.EncodingConstraint.DEFAULT)) {
            tmp.addAll(ConstraintSignPolicy.EncodingConstraint.DEFAULT);
        }
        if (tmp.isEmpty()) {
            throw new IllegalArgumentException("at least one encoding must be specified - directly or indirectly using default");
        }
        return tmp;
    }

    @Override
    public final List<ConstraintSignPolicy.EncodingConstraint> getEncodings() {
        return this.encodings;
    }

    @Override
    public boolean useDefaultEncodings() {
        return this.encodings.containsAll(ConstraintSignPolicy.EncodingConstraint.DEFAULT);
    }
}

