/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.UnsignedProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SignerInfoImpl
implements SignerInfo {
    private String signatureAlgorithmUri;
    private String digestAlgorithmUri;
    private SignedProperties signedProperties;
    private UnsignedProperties unsignedProperties;
    private PrivateKeyResourceReferenceParameter key;

    public SignerInfoImpl() {
        this.signatureAlgorithmUri = null;
        this.digestAlgorithmUri = null;
        this.signedProperties = new SignedProperties();
        this.unsignedProperties = new UnsignedProperties();
        this.key = null;
    }

    public SignerInfoImpl(SignerInfo info) {
        this.signatureAlgorithmUri = info.getSignatureAlgorithmURI();
        this.digestAlgorithmUri = info.getDigestAlgorithmURI();
        this.signedProperties = info.getSignedProperties();
        this.unsignedProperties = info.getUnsignedProperties();
        this.key = info.getKey();
    }

    @Override
    public String getSignatureAlgorithmURI() {
        return this.signatureAlgorithmUri;
    }

    protected void setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signatureAlgorithmUri = signatureAlgorithmURI;
    }

    @Override
    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmUri;
    }

    protected void setDigestAlgorithmURI(String digestAlgorithmURI) {
        this.digestAlgorithmUri = digestAlgorithmURI;
    }

    @Override
    public SignedProperties getSignedProperties() {
        return this.signedProperties;
    }

    protected void setSignedProperties(SignedProperties properties) {
        this.signedProperties = properties;
    }

    protected void addSignedProperty(SignedProperty property) {
        this.signedProperties.add(property);
    }

    protected void removeSignedProperty(SignedProperty property) {
        this.signedProperties.remove(property);
    }

    @Override
    public UnsignedProperties getUnsignedProperties() {
        return this.unsignedProperties;
    }

    void setUnsignedProperties(UnsignedProperties properties) {
        this.unsignedProperties = properties;
    }

    void addUnsignedProperty(UnsignedProperty property) {
        this.unsignedProperties.add(property);
    }

    public void removeUnsignedProperty(UnsignedProperty property) {
        this.unsignedProperties.remove(property);
    }

    public List<SignProperty> getProperties() {
        ArrayList<SignProperty> result = new ArrayList<SignProperty>();
        for (SignProperty property : this.getSignedProperties()) {
            result.add(property);
        }
        for (SignProperty property : this.getUnsignedProperties()) {
            result.add(property);
        }
        return result;
    }

    protected void setProperties(Collection<? extends SignProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.getSignedProperties().clear();
        this.getUnsignedProperties().clear();
        for (SignProperty signProperty : properties) {
            if (signProperty != null) continue;
        }
    }

    protected void addProperties(Collection<? extends SignProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (SignProperty signProperty : properties) {
            if (signProperty == null) continue;
            this.addProperty(signProperty);
        }
    }

    protected <T extends SignProperty> void addProperty(T property) {
        if (property == null) {
            return;
        }
        if (SignedProperty.class.isInstance(property)) {
            this.addSignedProperty((SignedProperty)SignedProperty.class.cast(property));
        }
        if (UnsignedProperty.class.isInstance(property)) {
            this.addUnsignedProperty((UnsignedProperty)UnsignedProperty.class.cast(property));
        }
    }

    protected <T extends SignProperty> void removeProperty(T property) {
        if (property == null) {
            return;
        }
        if (SignedProperty.class.isInstance(property)) {
            this.removeSignedProperty((SignedProperty)SignedProperty.class.cast(property));
        }
        if (UnsignedProperty.class.isInstance(property)) {
            this.removeUnsignedProperty((UnsignedProperty)UnsignedProperty.class.cast(property));
        }
    }

    protected void removeProperties(Collection<? extends SignProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (SignProperty signProperty : properties) {
            if (signProperty == null) continue;
            this.removeProperty(signProperty);
        }
    }

    @Override
    public PrivateKeyResourceReferenceParameter getKey() {
        return this.key;
    }

    protected void setKeyResourceReference(PrivateKeyResourceReferenceParameter key) {
        this.key = key;
    }
}

