/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.jcebase.DefaultDigestAlgorithmURIFinder;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.impl.SignerInfoImpl;
import java.util.Collection;
import java.util.List;

public class SignerInfoBuilder {
    private SignerInfoImpl signerInfo;

    public String getDigestAlgorithmURI() {
        return this.signerInfo.getDigestAlgorithmURI();
    }

    public SignerInfoBuilder setDigestAlgorithmURI(String digestAlgorithmURI) {
        this.signerInfo.setDigestAlgorithmURI(digestAlgorithmURI);
        return this;
    }

    public SignerInfoBuilder setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signerInfo.setSignatureAlgorithmURI(signatureAlgorithmURI);
        return this;
    }

    public String getSignatureAlgorithmURI() {
        return this.signerInfo.getSignatureAlgorithmURI();
    }

    public SignedProperties getSignedProperties() {
        return this.signerInfo.getSignedProperties();
    }

    public SignerInfoBuilder setSignedProperties(SignedProperties properties) {
        this.signerInfo.setSignedProperties(properties);
        return this;
    }

    public SignerInfoBuilder addSignedProperty(SignedProperty property) {
        this.signerInfo.addSignedProperty(property);
        return this;
    }

    public SignerInfoBuilder removeSignedProperty(SignedProperty property) {
        this.signerInfo.removeSignedProperty(property);
        return this;
    }

    public List<UnsignedProperty> getUnsignedProperties() {
        return this.signerInfo.getUnsignedProperties();
    }

    public SignerInfoBuilder setUnsignedProperties(UnsignedProperties properties) {
        this.signerInfo.setUnsignedProperties(properties);
        return this;
    }

    public SignerInfoBuilder addUnsignedProperty(UnsignedProperty property) {
        this.signerInfo.addUnsignedProperty(property);
        return this;
    }

    public SignerInfoBuilder removeUnsignedProperty(UnsignedProperty property) {
        this.signerInfo.removeUnsignedProperty(property);
        return this;
    }

    public List<? extends SignProperty> getProperties() {
        return this.signerInfo.getProperties();
    }

    public SignerInfoBuilder setProperties(List<? extends SignProperty> properties) {
        this.signerInfo.setProperties(properties);
        return this;
    }

    public <T extends SignProperty> SignerInfoBuilder addProperty(T property) {
        this.signerInfo.addProperty(property);
        return this;
    }

    public <T extends SignProperty> SignerInfoBuilder removeProperty(T property) {
        this.signerInfo.removeProperty(property);
        return this;
    }

    public <T extends SignProperty> SignerInfoBuilder addProperties(Collection<? extends SignProperty> properties) {
        this.signerInfo.addProperties(properties);
        return this;
    }

    public <T extends SignProperty> SignerInfoBuilder removeProperties(Collection<? extends SignProperty> properties) {
        this.signerInfo.removeProperties(properties);
        return this;
    }

    public PrivateKeyResourceReferenceParameter getKey() {
        return this.signerInfo.getKey();
    }

    public SignerInfoBuilder setKey(PrivateKeyResourceReferenceParameter key) {
        this.signerInfo.setKeyResourceReference(key);
        return this;
    }

    public SignerInfoBuilder() {
        this.signerInfo = new SignerInfoImpl();
    }

    public SignerInfoBuilder(SignerInfo signerInfo) {
        if (!(signerInfo instanceof SignerInfoImpl)) {
            throw new IllegalArgumentException("only SignerInfoImpl currently supported");
        }
        this.signerInfo = (SignerInfoImpl)signerInfo;
    }

    public SignerInfo build() {
        if (this.signerInfo != null && (this.signerInfo.getDigestAlgorithmURI() == null || this.signerInfo.getDigestAlgorithmURI().isEmpty())) {
            this.signerInfo.setDigestAlgorithmURI(DefaultDigestAlgorithmURIFinder.getFinder().getDigestAlgorithmURI(this.signerInfo.getSignatureAlgorithmURI()));
        }
        return this.signerInfo;
    }
}

