/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.res.CertificateValidationServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.TimestampServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.TrustedAnchorServiceResourceReferenceParameter;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.SignerInfo;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SignOptionsImpl
implements SignOptions {
    protected SignPolicy policy;
    protected Set<Class<? extends Document>> documentFormatClasses;
    protected Set<SignerInfo> signerInfos;
    protected SignerInfo defaultSignerInfo;
    protected TimestampServiceResourceReferenceParameter defaultTimestampService;
    protected TrustedAnchorServiceResourceReferenceParameter defaultTrustedAnchorService;
    protected CertificateValidationServiceResourceReferenceParameter defaultCertificateValidationService;
    protected SignatureType signatureType;
    protected String pluginId;
    private OutputStream outputStream;
    private String outputStreamMetaInf;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public SignOptionsImpl(SignOptions signOptions) throws IllegalArgumentException {
        if (signOptions == null) {
            throw new IllegalArgumentException("Copy-Constructor only usable for existing SignOptions");
        }
        this.policy = (SignPolicy)signOptions.getPolicy();
        this.signatureType = signOptions.getSignatureType();
        this.pluginId = signOptions.getPluginID();
        this.documentFormatClasses = SignOptionsImpl.checkSetNotNullOrEmptyOrContainsOnlyNull(signOptions.getInputDocumentFormatClasses(), "Document class");
        this.signerInfos = signOptions.getSignerInfos();
        this.defaultSignerInfo = signOptions.getDefaultSignerInfo();
        this.defaultTimestampService = signOptions.getDefaultTimestampService();
        this.defaultCertificateValidationService = signOptions.getDefaultCertificateValidationService();
        this.defaultTrustedAnchorService = signOptions.getDefaultTrustedAnchorService();
    }

    public static <E> Set<E> checkSetNotNullOrEmptyOrContainsOnlyNull(Set<E> uncheckedSet, String msg) throws IllegalArgumentException {
        if (uncheckedSet == null || uncheckedSet.isEmpty()) {
            throw new IllegalArgumentException("at least one " + msg + " must exist");
        }
        LinkedHashSet<E> checkedSet = new LinkedHashSet<E>(uncheckedSet);
        checkedSet.remove(null);
        if (checkedSet.isEmpty()) {
            throw new IllegalArgumentException("at least one " + msg + " must exist, that is not null");
        }
        return checkedSet;
    }

    public SignOptionsImpl() {
        this((Set<Class<? extends Document>>)null);
    }

    public SignOptionsImpl(Plugin.PluginID pluginId, SignatureType signatureType, Set<Class<? extends Document>> documentFormatClasses) {
        this(pluginId, null, signatureType, documentFormatClasses);
    }

    public SignOptionsImpl(Plugin.PluginID pluginId, SignPolicy signPolicy, SignatureType signatureType, Set<Class<? extends Document>> documentFormatClasses) {
        this.policy = signPolicy;
        this.signatureType = signatureType;
        this.documentFormatClasses = documentFormatClasses;
        this.pluginId = pluginId == null ? null : pluginId.getID();
        this.signerInfos = new LinkedHashSet<SignerInfo>();
        this.defaultSignerInfo = null;
        this.defaultTimestampService = null;
        this.defaultCertificateValidationService = null;
        this.defaultTrustedAnchorService = null;
    }

    public SignOptionsImpl(Set<Class<? extends Document>> documentFormatClasses) {
        this(null, null, documentFormatClasses);
    }

    @Override
    public SignPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public Set<Class<? extends Document>> getInputDocumentFormatClasses() {
        return this.documentFormatClasses;
    }

    @Override
    public String getPluginID() {
        return this.pluginId;
    }

    @Override
    public Set<SignerInfo> getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public SignerInfo getDefaultSignerInfo() {
        return this.defaultSignerInfo;
    }

    void setSignerInfos(Set<SignerInfo> signerInfos) {
        this.signerInfos = signerInfos;
    }

    void addSignerInfo(SignerInfo signerInfo) {
        if (signerInfo == null) {
            return;
        }
        this.signerInfos.add(signerInfo);
    }

    void removeSignerInfo(SignerInfo signerInfo) {
        this.signerInfos.remove(signerInfo);
    }

    void setDefaultSignerInfo(SignerInfo defaultSignerInfo) {
        this.defaultSignerInfo = defaultSignerInfo;
    }

    void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    void setPluginID(String id) {
        this.pluginId = id;
    }

    void setInputdocumentFormatClasses(Set<Class<? extends Document>> inputDocumentClasses) {
        this.documentFormatClasses = Collections.unmodifiableSet(SignOptionsImpl.checkSetNotNullOrEmptyOrContainsOnlyNull(inputDocumentClasses, "Document format class"));
    }

    @Override
    public TimestampServiceResourceReferenceParameter getDefaultTimestampService() {
        return this.defaultTimestampService;
    }

    @Override
    public TrustedAnchorServiceResourceReferenceParameter getDefaultTrustedAnchorService() {
        return this.defaultTrustedAnchorService;
    }

    @Override
    public CertificateValidationServiceResourceReferenceParameter getDefaultCertificateValidationService() {
        return this.defaultCertificateValidationService;
    }

    void setDefaultTimestampService(TimestampServiceResourceReferenceParameter timestampService) {
        this.defaultTimestampService = timestampService;
    }

    void setDefaultTrustedAnchorService(TrustedAnchorServiceResourceReferenceParameter trustedAnchorService) {
        this.defaultTrustedAnchorService = trustedAnchorService;
    }

    void setDefaultCertificateValidationService(CertificateValidationServiceResourceReferenceParameter certificateValidationService) {
        this.defaultCertificateValidationService = certificateValidationService;
    }

    void setPolicy(SignPolicy policy) {
        this.policy = policy;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public String getOutputStreamMetaInf() {
        return this.outputStreamMetaInf;
    }

    public void setOutputStreamMetaInf(String outputStreamMetaInf) {
        this.outputStreamMetaInf = outputStreamMetaInf;
    }
}

