/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.CollectionRequestCheckRule;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.RequestCheckRule;
import de.governikus.csl.uom.impl.Cardinality;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.props.CertificateValues;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.RevocationValues;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.sign.props.SigningTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PreRequestCheckerRegistry {
    public static final SignPropertyCheckRule<SignedProperty> RULE_SIGNING_CERTIFICATE_EXISTS = new SignPropertyCheckRule<SigningCertificate>(Cardinality.ONE, SigningCertificate.class);
    public static final SignPropertyCheckRule<SignedProperty> RULE_SIGNING_TIME_EXISTS = new SignPropertyCheckRule<SigningTime>(Cardinality.ZERO_OR_ONE, SigningTime.class);
    public static final SignPropertyCheckRule<UnsignedProperty> RULE_SIGNATURE_TIMESTAMP_EXISTS = new SignPropertyCheckRule<SignatureTimestamp>(Cardinality.ONE_OR_MORE, SignatureTimestamp.class);
    public static final SignPropertyCheckRule<UnsignedProperty> RULE_REVOCATION_VALUES_EXISTS = new SignPropertyCheckRule<RevocationValues>(Cardinality.ONE, RevocationValues.class);
    public static final SignPropertyCheckRule<UnsignedProperty> RULE_RESTRICTION_CERTIFICATE_VALUES_EXISTS = new SignPropertyCheckRule<CertificateValues>(Cardinality.ONE, CertificateValues.class);
    private static PreRequestCheckerRegistry registry;

    private PreRequestCheckerRegistry() {
    }

    public static synchronized PreRequestCheckerRegistry getRegistry() {
        if (registry == null) {
            registry = new PreRequestCheckerRegistry();
        }
        return registry;
    }

    public void check(SignRequest signRequest) throws CoreException {
        SignPolicy policy = (SignPolicy)((SignOptions)signRequest.getOptions()).getPolicy();
        if (policy == null || !ConstraintSignPolicy.class.isInstance(policy)) {
            return;
        }
        ConstraintSignPolicy.SignatureLevel targetSignatureLevel = ((ConstraintSignPolicy)ConstraintSignPolicy.class.cast(policy)).getSignatureLevel();
        PreRequestCheckerRegistry.check(SignRequestSignatureLevelCheckRule.valueOf(targetSignatureLevel), targetSignatureLevel, signRequest);
    }

    public static void check(SignRequestSignatureLevelCheckRule targetSignRequestSignatureLevelCheckRule, ConstraintSignPolicy.SignatureLevel targetSignatureLevel, SignRequest signRequest) throws CoreException {
        ConstraintSignPolicy.SignatureLevel lSignatureLevel;
        if (targetSignatureLevel == null && targetSignRequestSignatureLevelCheckRule == null) {
            throw new IllegalArgumentException("signature level and rule can not be null at the same time");
        }
        SignRequestSignatureLevelCheckRule lPolicySignPropertiesLevelRule = targetSignRequestSignatureLevelCheckRule != null ? targetSignRequestSignatureLevelCheckRule : SignRequestSignatureLevelCheckRule.valueOf(targetSignatureLevel);
        ConstraintSignPolicy.SignatureLevel signatureLevel = lSignatureLevel = targetSignatureLevel != null ? targetSignatureLevel : PreRequestCheckerRegistry.getSignatureLevel(targetSignRequestSignatureLevelCheckRule);
        if (signRequest == null) {
            throw new IllegalArgumentException("SignRequest can not be null");
        }
        if (lSignatureLevel != PreRequestCheckerRegistry.getSignatureLevel(lPolicySignPropertiesLevelRule)) {
            throw new IllegalArgumentException("not valid arguments used, rule must match signature level: " + (Object)((Object)lSignatureLevel) + " != " + (Object)((Object)PreRequestCheckerRegistry.getSignatureLevel(lPolicySignPropertiesLevelRule)));
        }
        lPolicySignPropertiesLevelRule.check(signRequest);
    }

    public static ConstraintSignPolicy.SignatureLevel getSignatureLevel(SignRequestSignatureLevelCheckRule policySignPropertiesLevelRule) {
        if (policySignPropertiesLevelRule == null) {
            return null;
        }
        return policySignPropertiesLevelRule.getSignatureLevel();
    }

    public static enum SignRequestSignatureLevelCheckRule implements SignRequestCheckRule
    {
        NONE(ConstraintSignPolicy.SignatureLevel.NONE, null),
        B(ConstraintSignPolicy.SignatureLevel.B, Arrays.asList(RULE_SIGNING_CERTIFICATE_EXISTS, RULE_SIGNING_TIME_EXISTS)),
        T(B, ConstraintSignPolicy.SignatureLevel.T, Arrays.asList(RULE_SIGNATURE_TIMESTAMP_EXISTS)),
        LT(T, ConstraintSignPolicy.SignatureLevel.LT, Arrays.asList(RULE_REVOCATION_VALUES_EXISTS, RULE_RESTRICTION_CERTIFICATE_VALUES_EXISTS)),
        LTA(LT, ConstraintSignPolicy.SignatureLevel.LTA, null);

        private final SignRequestSignatureLevelCheckRule parentRule;
        private final ConstraintSignPolicy.SignatureLevel signatureLevel;
        private final List<SignRequestCheckRule> children;
        private List<SignRequestCheckRule> cachedRules;

        private SignRequestSignatureLevelCheckRule(ConstraintSignPolicy.SignatureLevel signatureLevel, List<SignRequestCheckRule> children) {
            this(null, signatureLevel, children);
        }

        private SignRequestSignatureLevelCheckRule(SignRequestSignatureLevelCheckRule parentRule, ConstraintSignPolicy.SignatureLevel signatureLevel, List<SignRequestCheckRule> children) {
            this.parentRule = parentRule;
            this.signatureLevel = signatureLevel;
            this.children = children == null ? Collections.emptyList() : children;
        }

        @Override
        public SignRequestSignatureLevelCheckRule getParentRule() {
            return this.parentRule;
        }

        public ConstraintSignPolicy.SignatureLevel getSignatureLevel() {
            return this.signatureLevel;
        }

        @Override
        public List<SignRequestCheckRule> getChildren() {
            return this.children;
        }

        public static SignRequestSignatureLevelCheckRule valueOf(ConstraintSignPolicy.SignatureLevel signatureLevel) {
            if (signatureLevel == null) {
                return null;
            }
            for (SignRequestSignatureLevelCheckRule value : SignRequestSignatureLevelCheckRule.values()) {
                if (signatureLevel != value.getSignatureLevel()) continue;
                return value;
            }
            return null;
        }

        @Override
        public synchronized List<SignRequestCheckRule> getCachedRules() {
            if (this.cachedRules == null) {
                this.cachedRules = this.getRules();
            }
            return this.cachedRules;
        }

        @Override
        public void check(SignRequest signRequest) throws CoreException {
            List<SignRequestCheckRule> checkRules = this.getCachedRules();
            if (checkRules != null && !checkRules.isEmpty()) {
                for (SignRequestCheckRule checkRule : checkRules) {
                    for (SignRequestCheckRule childRule : checkRule.getChildren()) {
                        if (childRule instanceof CollectionRequestCheckRule && ((CollectionRequestCheckRule)((Object)childRule)).getCollectionType().equals(SignerInfo.class)) {
                            ((CollectionRequestCheckRule)((Object)childRule)).check(((SignOptions)signRequest.getOptions()).getSignerInfos());
                            continue;
                        }
                        childRule.check(signRequest);
                    }
                }
            }
        }
    }

    public static class SignPropertyCheckRule<S extends SignProperty>
    implements CollectionSignRequestCheckRule<SignerInfo> {
        private final Cardinality cardinality;
        private final Class<? extends S> propertyTypeClass;

        @Override
        public Class<SignerInfo> getCollectionType() {
            return SignerInfo.class;
        }

        public SignPropertyCheckRule(Cardinality cardinality, Class<? extends S> propertyTypeClass) {
            this.cardinality = Objects.requireNonNull(cardinality);
            this.propertyTypeClass = Objects.requireNonNull(propertyTypeClass);
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public Class<? extends S> getPropertyTypeClass() {
            return this.propertyTypeClass;
        }

        @Override
        public void check(int count) throws CoreException {
            String basePrefixErrorMessage = "count '" + count + "' of property '" + this.propertyTypeClass + "' not satisfied: ";
            if (!this.cardinality.check(count)) {
                switch (this.cardinality) {
                    case NONE: {
                        throw new CoreException(basePrefixErrorMessage + "none expected");
                    }
                    case ONE_OR_MORE: {
                        throw new CoreException(basePrefixErrorMessage + "one or more expected");
                    }
                    case ZERO_OR_ONE: {
                        throw new CoreException(basePrefixErrorMessage + "zero or one expected");
                    }
                    case ONE: {
                        throw new CoreException(basePrefixErrorMessage + "exactly one is expected");
                    }
                    case ZERO_OR_MORE: {
                        throw new CoreException(basePrefixErrorMessage + "zero or more expected");
                    }
                }
            }
        }

        @Override
        public void check(Collection<SignerInfo> collection) throws CoreException {
            if (collection == null) {
                return;
            }
            for (SignerInfo signerInfo : collection) {
                this.check(signerInfo);
            }
        }

        @Override
        private void check(SignerInfo signerInfo) throws CoreException {
            int count = PropertiesUtil.findProperties(this.getPropertyTypeClass(), signerInfo.getProperties()).size();
            this.check(count);
        }
    }

    public static interface CollectionSignRequestCheckRule<T>
    extends SignRequestCheckRule,
    CollectionRequestCheckRule<T> {
    }

    public static interface SignRequestCheckRule
    extends RequestCheckRule<SignPolicy, SignOptions, SignRequest, SignRequestCheckRule> {
    }
}

