/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class EncodingConstraintHelper {
    private static final List<ConstraintSignPolicy.EncodingConstraint> SPEC_ONLY = Collections.singletonList(ConstraintSignPolicy.EncodingConstraint.SPEC);

    private EncodingConstraintHelper() {
    }

    public static List<ConstraintSignPolicy.EncodingConstraint> buildEncodingConstraints(SignPolicy signPolicy, SignProperty property) throws IOException {
        if (signPolicy == null) {
            if (property == null) {
                throw new IOException("policy and property null, no encoding constraint can be determined");
            }
            return EncodingConstraintHelper.copy(property.getEncodings());
        }
        return EncodingConstraintHelper.buildEncodingConstraintList(signPolicy instanceof ConstraintSignPolicy ? ((ConstraintSignPolicy)signPolicy).getEncodingConstraints() : SPEC_ONLY, property == null ? null : property.getEncodings());
    }

    public static List<ConstraintSignPolicy.EncodingConstraint> buildEncodingConstraintList(List<ConstraintSignPolicy.EncodingConstraint> majorEncodings, List<ConstraintSignPolicy.EncodingConstraint> minorEncodings) throws IOException {
        boolean minorEncodingsNotSpecified;
        boolean majorEncodingsNotSpecified = majorEncodings == null || majorEncodings.isEmpty();
        boolean bl = minorEncodingsNotSpecified = minorEncodings == null || minorEncodings.isEmpty();
        if (majorEncodingsNotSpecified && minorEncodingsNotSpecified) {
            throw new IOException("major and minor encodings can not be null at the same time, no encoding constraint can be determined at all");
        }
        if (!majorEncodingsNotSpecified && minorEncodingsNotSpecified) {
            return EncodingConstraintHelper.copy(majorEncodings);
        }
        if (majorEncodingsNotSpecified) {
            return EncodingConstraintHelper.copy(minorEncodings);
        }
        if (SPEC_ONLY.equals(majorEncodings)) {
            return EncodingConstraintHelper.copy(minorEncodings);
        }
        if (majorEncodings.size() == 1) {
            return EncodingConstraintHelper.copy(majorEncodings);
        }
        return EncodingConstraintHelper.copy(majorEncodings, minorEncodings);
    }

    private static List<ConstraintSignPolicy.EncodingConstraint> copy(List<ConstraintSignPolicy.EncodingConstraint> firstList) throws IOException {
        return EncodingConstraintHelper.copy(firstList, null);
    }

    private static List<ConstraintSignPolicy.EncodingConstraint> copy(List<ConstraintSignPolicy.EncodingConstraint> firstList, List<ConstraintSignPolicy.EncodingConstraint> secondList) throws IOException {
        ArrayList<ConstraintSignPolicy.EncodingConstraint> encodings = new ArrayList<ConstraintSignPolicy.EncodingConstraint>();
        encodings.addAll(firstList);
        if (secondList != null) {
            encodings.addAll(secondList);
        }
        EncodingConstraintHelper.cleanEncodings(encodings);
        if (encodings.isEmpty()) {
            throw new IOException("result encodings are empty, no encoding constraint can be determined at all");
        }
        return encodings;
    }

    private static void cleanEncodings(List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        while (encodings.contains(null)) {
            encodings.remove(null);
        }
        while (encodings.contains((Object)ConstraintSignPolicy.EncodingConstraint.SPEC)) {
            encodings.remove((Object)ConstraintSignPolicy.EncodingConstraint.SPEC);
        }
    }
}

