/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.impl;

import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.impl.PolicyInformationBuilder;
import de.governikus.csl.uom.impl.SimplePolicyInformationImpl;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.impl.ConstraintSignPolicyBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConstraintSignPolicyImpl
implements ConstraintSignPolicy {
    public static final SimplePolicyInformationImpl DEFAULT_POLICY_INFORMATION_GOVERNIKUS = new PolicyInformationBuilder().setVersion("1.0").setAuthor("Governikus").build();
    public static final ConstraintSignPolicy ADES_QES_B_TS = new ConstraintSignPolicyBuilder().setId("1.2.3.4.1").setName("ADES_QES_B_TS").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.B).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_TS).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_B_EN = new ConstraintSignPolicyBuilder().setId("1.2.3.4.2").setName("ADES_QES_B_EN").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.B).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_EN).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_T_TS = new ConstraintSignPolicyBuilder().setId("1.2.3.5.1").setName("ADES_QES_T_TS").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.T).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_TS).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_T_EN = new ConstraintSignPolicyBuilder().setId("1.2.3.5.2").setName("ADES_QES_T_EN").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.T).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_EN).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_LT_TS = new ConstraintSignPolicyBuilder().setId("1.2.3.6.1").setName("ADES_QES_LT_TS").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.LT).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_TS).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_LT_EN = new ConstraintSignPolicyBuilder().setId("1.2.3.6.2").setName("ADES_QES_LT_EN").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.LT).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_EN).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_LTA_TS = new ConstraintSignPolicyBuilder().setId("1.2.3.7.1").setName("ADES_QES_LTA_TS").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.LTA).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_TS).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final ConstraintSignPolicy ADES_QES_LTA_EN = new ConstraintSignPolicyBuilder().setId("1.2.3.7.2").setName("ADES_QES_LTA_EN").setCertificateLevel(ConstraintSignPolicy.CertificateLevel.EU_ADES_QES).setSignaturLevel(ConstraintSignPolicy.SignatureLevel.LTA).setEncodingConstraint(ConstraintSignPolicy.EncodingConstraint.ETSI_EN).setPolicyInformation(DEFAULT_POLICY_INFORMATION_GOVERNIKUS).build();
    public static final String DEFAULT_ID = "noId";
    public static final String DEFAULT_NAME = "noName";
    public static final List<ConstraintSignPolicy.EncodingConstraint> DEFAULT_ENCODINGS = Collections.unmodifiableList(new ArrayList());
    private String id = "noId";
    private String name = "noName";
    private PolicyInformation policyInformation;
    private ConstraintSignPolicy.SignatureLevel signatureLevel;
    private List<ConstraintSignPolicy.EncodingConstraint> encodingConstraints = DEFAULT_ENCODINGS;
    private ConstraintSignPolicy.CertificateLevel certificateLevel;
    private String sorterName = "AdES_EN_TS";

    public ConstraintSignPolicyImpl() {
    }

    public ConstraintSignPolicyImpl(ConstraintSignPolicy copy) {
        this.setCertificateLevel(copy.getCertificateLevel());
        this.setEncodingConstraints(copy.getEncodingConstraints());
        this.setId(copy.getId());
        this.setName(copy.getName());
        this.setPolicyInformation(copy.getPolicyInformation());
        this.setSignatureLevel(copy.getSignatureLevel());
        this.setSortMechanismName(copy.getSortMechanismName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificateLevel == null ? 0 : this.certificateLevel.hashCode());
        result = 31 * result + (this.encodingConstraints == null ? 0 : this.encodingConstraints.hashCode());
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.policyInformation == null ? 0 : this.policyInformation.hashCode());
        result = 31 * result + (this.signatureLevel == null ? 0 : this.signatureLevel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() && !ConstraintSignPolicyImpl.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ConstraintSignPolicyImpl other = (ConstraintSignPolicyImpl)obj;
        if (this.certificateLevel != other.certificateLevel) {
            return false;
        }
        if (this.encodingConstraints == null ? other.encodingConstraints != null : !this.encodingConstraints.equals(other.encodingConstraints)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.policyInformation == null ? other.policyInformation != null : !this.policyInformation.equals(other.policyInformation)) {
            return false;
        }
        return this.signatureLevel == other.signatureLevel;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PolicyInformation getPolicyInformation() {
        return this.policyInformation;
    }

    @Override
    public ConstraintSignPolicy.SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    @Override
    public List<ConstraintSignPolicy.EncodingConstraint> getEncodingConstraints() {
        return this.encodingConstraints;
    }

    @Override
    public ConstraintSignPolicy.CertificateLevel getCertificateLevel() {
        return this.certificateLevel;
    }

    public void setId(String id) {
        this.id = Objects.requireNonNull(id, "id can not be null");
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "name can not be null");
    }

    public void setPolicyInformation(PolicyInformation policyInformation) {
        this.policyInformation = policyInformation;
    }

    public void setSignatureLevel(ConstraintSignPolicy.SignatureLevel signatureLevel) {
        this.signatureLevel = signatureLevel;
    }

    public void setEncodingConstraints(List<ConstraintSignPolicy.EncodingConstraint> encodingConstraints) {
        this.encodingConstraints = encodingConstraints;
    }

    public void setCertificateLevel(ConstraintSignPolicy.CertificateLevel certificateLevel) {
        this.certificateLevel = certificateLevel;
    }

    public void setSortMechanismName(String sorterName) {
        this.sorterName = sorterName;
    }

    @Override
    public String getSortMechanismName() {
        return this.sorterName;
    }
}

