/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.ades;

import de.governikus.csl.uom.NamedPolicy;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.impl.ConstraintSignPolicyImpl;
import java.util.List;

public enum AdESSignCreationPolicy implements ConstraintSignPolicy
{
    AdES_B_B(ConstraintSignPolicyImpl.ADES_QES_B_TS),
    AdES_B_T(ConstraintSignPolicyImpl.ADES_QES_T_TS),
    AdES_B_LT(ConstraintSignPolicyImpl.ADES_QES_LT_TS),
    AdES_EN_B_B(ConstraintSignPolicyImpl.ADES_QES_B_EN),
    AdES_EN_B_T(ConstraintSignPolicyImpl.ADES_QES_T_EN),
    AdES_EN_B_LT(ConstraintSignPolicyImpl.ADES_QES_LT_EN);

    private final ConstraintSignPolicy delegate;

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ConstraintSignPolicy.SignatureLevel getSignatureLevel() {
        return this.delegate.getSignatureLevel();
    }

    @Override
    public List<ConstraintSignPolicy.EncodingConstraint> getEncodingConstraints() {
        return this.delegate.getEncodingConstraints();
    }

    @Override
    public ConstraintSignPolicy.CertificateLevel getCertificateLevel() {
        return this.delegate.getCertificateLevel();
    }

    private AdESSignCreationPolicy(ConstraintSignPolicy delegate) {
        this.delegate = delegate;
    }

    public static AdESSignCreationPolicy getPolicy(NamedPolicy policy) {
        if (policy == null) {
            return null;
        }
        AdESSignCreationPolicy result = AdESSignCreationPolicy.getPolicy(policy);
        if (result == null) {
            result = AdESSignCreationPolicy.getPolicyById(policy.getId());
        }
        if (result == null) {
            result = AdESSignCreationPolicy.getPolicyByName(policy.getName());
        }
        return result;
    }

    public static AdESSignCreationPolicy getPolicy(SignPolicy policy) {
        if (policy == null) {
            return null;
        }
        for (AdESSignCreationPolicy value : AdESSignCreationPolicy.values()) {
            if (value != policy && value.delegate != policy) continue;
            return value;
        }
        return null;
    }

    public static AdESSignCreationPolicy getPolicyById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (AdESSignCreationPolicy value : AdESSignCreationPolicy.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }

    public static AdESSignCreationPolicy getPolicyByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (AdESSignCreationPolicy value : AdESSignCreationPolicy.values()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }

    @Override
    public PolicyInformation getPolicyInformation() {
        return this.delegate.getPolicyInformation();
    }
}

