/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign;

import de.governikus.csl.uom.sign.SignPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface ConstraintSignPolicy
extends SignPolicy {
    public SignatureLevel getSignatureLevel();

    public List<EncodingConstraint> getEncodingConstraints();

    public CertificateLevel getCertificateLevel();

    default public String getSortMechanismName() {
        return "AdES_EN_TS";
    }

    public static enum CertificateLevel {
        SIMPLE,
        ADVANCED,
        SIG_QES,
        EU_ADES_QES;

        public static final CertificateLevel QES;
        public static final CertificateLevel DEFAULT;

        static {
            DEFAULT = QES = EU_ADES_QES;
        }
    }

    public static enum EncodingConstraint {
        SPEC,
        ETSI_TS,
        ETSI_EN;

        public static final List<EncodingConstraint> ETSI_TS_EN;
        public static final List<EncodingConstraint> ETSI_EN_TS;
        public static final List<EncodingConstraint> ETSI_TS_EN_SPEC;
        public static final List<EncodingConstraint> ETSI_EN_TS_SPEC;
        public static final List<EncodingConstraint> QES;
        public static final List<EncodingConstraint> DEFAULT;

        static {
            ETSI_TS_EN = Collections.unmodifiableList(Arrays.asList(ETSI_EN, ETSI_TS));
            ETSI_EN_TS = Collections.unmodifiableList(Arrays.asList(ETSI_TS, ETSI_EN));
            ETSI_TS_EN_SPEC = Collections.unmodifiableList(Arrays.asList(ETSI_TS, ETSI_EN, SPEC));
            ETSI_EN_TS_SPEC = Collections.unmodifiableList(Arrays.asList(ETSI_EN, ETSI_TS, SPEC));
            QES = ETSI_EN_TS;
            DEFAULT = QES;
        }
    }

    public static enum SignatureLevel {
        NONE,
        B,
        T,
        LT,
        LTA;

        public static final SignatureLevel QES;
        public static final SignatureLevel DEFAULT;

        static {
            DEFAULT = QES = B;
        }
    }
}

