/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.service;

import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.service.Service;
import de.governikus.csl.uom.service.ServiceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public final class ServiceLoaderManager
implements ServiceManager {
    private static ServiceLoaderManager SINGLETON;
    private Map<Class<? extends Service<InstanceProvider>>, ServiceLoader<? extends Service<InstanceProvider>>> serviceMap = new HashMap<Class<? extends Service<InstanceProvider>>, ServiceLoader<? extends Service<InstanceProvider>>>();

    private ServiceLoaderManager() {
    }

    public static synchronized ServiceLoaderManager getManager() {
        if (SINGLETON == null) {
            SINGLETON = new ServiceLoaderManager();
        }
        return SINGLETON;
    }

    @Override
    public <S extends Service<InstanceProvider>> Iterable<S> getServices(Class<S> serviceClass) {
        return this.getServices(serviceClass, null);
    }

    @Override
    public <S extends Service<InstanceProvider>> Iterable<S> getServices(Class<S> serviceClass, ClassLoader classLoader) {
        ClassLoader lClassLoader;
        if (!Objects.requireNonNull(serviceClass, "service class can not be null").isInterface()) {
            throw new IllegalArgumentException("service interface class is required");
        }
        ClassLoader classLoader2 = lClassLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        if (!this.serviceMap.containsKey(serviceClass)) {
            this.serviceMap.put(serviceClass, ServiceLoader.load(serviceClass, lClassLoader));
        }
        return this.serviceMap.get(serviceClass);
    }
}

