/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.service;

import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.ServiceResourceReferenceState;
import de.governikus.csl.uom.service.Service;
import de.governikus.csl.uom.service.ServiceCategoryType;
import de.governikus.csl.uom.service.ServiceType;
import java.util.Objects;
import javax.enterprise.util.AnnotationLiteral;

public abstract class AbstractService
implements Service<InstanceProvider> {
    protected String name;
    protected String id;
    protected boolean enabled = true;
    protected boolean started = false;
    protected LockState lockState = LockState.NONE;
    protected InstanceProvider instanceProvider;

    public AbstractService() {
        this(null);
    }

    public AbstractService(String name) {
        if (!this.getClass().isAnnotationPresent(ServiceType.class)) {
            throw new IllegalArgumentException("ServiceType annotation must be present");
        }
        this.name = this.id = Objects.requireNonNull(this.getClass().getAnnotation(ServiceType.class).id().name(), "name of service can not be null");
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    public AbstractService(String name, Class<? extends Service> serviceClass) {
        if (!Objects.requireNonNull(serviceClass, "").isAnnotationPresent(ServiceType.class)) {
            throw new IllegalArgumentException("ServiceType annotation must be present");
        }
        this.name = this.id = Objects.requireNonNull(serviceClass.getAnnotation(ServiceType.class).id().name(), "name of service can not be null");
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized boolean setEnabled(boolean enabled) {
        if (this.isStarted()) {
            throw new IllegalStateException("service currently started, service can not be enabled or disabled in this state");
        }
        if (this.setEnabledInt(enabled)) {
            this.enabled = enabled;
            return true;
        }
        return false;
    }

    protected abstract boolean setEnabledInt(boolean var1);

    public boolean isStarted() {
        return this.started;
    }

    public static ServiceQualifier createServiceQualifier(Service.ServiceID id, Class<? extends Service<InstanceProvider>> type) {
        if (type.isAnnotationPresent(ServiceType.class)) {
            ServiceType serviceType = type.getAnnotation(ServiceType.class);
            return new ServiceQualifier(serviceType.id(), serviceType.type());
        }
        return new ServiceQualifier(id, type);
    }

    public static ServiceCategoryQualifier createServiceCategoryQualifier(Service.ServiceCategoryID id, Class<? extends Service<InstanceProvider>> type) {
        if (type.isAnnotationPresent(ServiceCategoryType.class)) {
            ServiceCategoryType serviceCategoryType = type.getAnnotation(ServiceCategoryType.class);
            return new ServiceCategoryQualifier(serviceCategoryType.id(), serviceCategoryType.type());
        }
        return new ServiceCategoryQualifier(id, type);
    }

    public void setManagerService(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    public LockState getLockState() {
        return this.lockState;
    }

    public void setLockState(LockState lockState) {
        this.lockState = lockState;
    }

    public ServiceResourceReferenceState getServiceState() {
        return this.getServiceReference().getServiceState();
    }

    public static class ServiceCategoryQualifier
    extends AnnotationLiteral<ServiceCategoryType>
    implements ServiceCategoryType {
        private static final long serialVersionUID = -4396641530837425975L;
        private Service.ServiceCategoryID id;
        private Class<? extends Service<InstanceProvider>> type;

        public ServiceCategoryQualifier(Service.ServiceCategoryID id, Class<? extends Service<InstanceProvider>> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Class<? extends Service<InstanceProvider>> type() {
            return this.type;
        }

        @Override
        public Service.ServiceCategoryID id() {
            return this.id;
        }
    }

    public static class ServiceQualifier
    extends AnnotationLiteral<ServiceType>
    implements ServiceType {
        private static final long serialVersionUID = -4396641530837425975L;
        private Service.ServiceID id;
        private Class<? extends Service<InstanceProvider>> type;

        public ServiceQualifier(Service.ServiceID id, Class<? extends Service<InstanceProvider>> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Class<? extends Service<InstanceProvider>> type() {
            return this.type;
        }

        @Override
        public Service.ServiceID id() {
            return this.id;
        }
    }
}

