/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.ServiceResource;
import de.governikus.csl.uom.res.ServiceResourceReference;
import de.governikus.csl.uom.res.management.AbstractResourceManager;
import de.governikus.csl.uom.res.management.ResourceManagerModel;
import de.governikus.csl.uom.res.management.ResourceProviderService;
import de.governikus.csl.uom.res.management.ResourceReferenceChangeListener;
import de.governikus.csl.uom.res.management.ResourceReferenceFilter;
import de.governikus.csl.uom.res.management.ResourceRegistry;
import de.governikus.csl.uom.res.management.StatefulResourceManager;
import de.governikus.csl.uom.service.ServiceManagerFactory;
import de.governikus.csl.uom.types.Configuration;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulResourceManagerImpl
extends AbstractResourceManager
implements StatefulResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatefulResourceManagerImpl.class.getName());
    private static StatefulResourceManagerImpl instance = null;
    private ResourceRegistry resourceManagerRegistryAdapter;
    private Map<ServiceResourceReference, Object> serviceLockMap;
    private List<ResourceProviderService> startedServices;
    private List<ResourceProviderService> services;
    private ResourceReferenceChangeListener listener = ResourceReferenceChangeListener.DEFAULT;
    private boolean started = false;
    private ResourceReferenceFilter filter = ResourceReferenceFilter.ALL;
    private boolean destroyed;

    public static synchronized StatefulResourceManager getInstance() {
        if (instance == null) {
            instance = new StatefulResourceManagerImpl();
        }
        return instance;
    }

    public static synchronized StatefulResourceManager getInstance(ResourceManagerModel model) {
        if (instance == null) {
            instance = new StatefulResourceManagerImpl(model);
        }
        return instance;
    }

    public StatefulResourceManagerImpl() {
        this.serviceLockMap = new HashMap<ServiceResourceReference, Object>();
        this.services = new ArrayList<ResourceProviderService>();
        this.startedServices = new ArrayList<ResourceProviderService>();
        this.resourceManagerRegistryAdapter = new ResourceRegistry(){

            @Override
            public <S extends Resource> boolean addResource(Object source, Object registryLock, S resource) {
                return StatefulResourceManagerImpl.this.addResource(source, registryLock, resource);
            }

            @Override
            public ResourceReferenceFilter getFilter() {
                return StatefulResourceManagerImpl.this.getFilter();
            }

            @Override
            public <S extends Resource> boolean removeResource(Object source, Object registryLock, S resource) {
                return StatefulResourceManagerImpl.this.removeResource(source, registryLock, resource);
            }

            @Override
            public <T extends ResourceReference> boolean removeResourceReference(Object source, Object registryLock, T resourceReference) {
                return StatefulResourceManagerImpl.this.removeResourceReference(source, registryLock, resourceReference);
            }
        };
        for (ResourceProviderService resourceProviderService : ServiceManagerFactory.getFactory().newServiceManager("ServiceLoader").getServices(ResourceProviderService.class)) {
            this.services.add(resourceProviderService);
        }
    }

    public StatefulResourceManagerImpl(ResourceManagerModel model) {
        super(model);
        this.serviceLockMap = new HashMap<ServiceResourceReference, Object>();
        this.services = new ArrayList<ResourceProviderService>();
        this.startedServices = new ArrayList<ResourceProviderService>();
        this.resourceManagerRegistryAdapter = new /* invalid duplicate definition of identical inner class */;
        for (ResourceProviderService resourceProviderService : ServiceManagerFactory.getFactory().newServiceManager("ServiceLoader").getServices(ResourceProviderService.class)) {
            this.services.add(resourceProviderService);
        }
    }

    private synchronized <S extends Resource> boolean addResource(Object source, Object registryLock, S resource) throws IllegalStateException {
        if (this.destroyed) {
            return false;
        }
        this.check(source, registryLock);
        if (resource == null || resource == ResourcesUtil.NO_RESOURCE_FOUND || resource == ResourcesUtil.NO_RESOURCE_SPECIFIED) {
            return false;
        }
        ResourceReference resourceReference = resource.getReference();
        if (resourceReference == null || resourceReference == ResourcesUtil.NO_RESOURCE_FOUND_REFERENCE || resourceReference == ResourcesUtil.NO_RESOURCE_SPECIFIED_REFERENCE) {
            return false;
        }
        boolean added = this.listener.addResourceReference(resourceReference);
        if (added) {
            this.resourceManagerModel.put(resource.getReference(), resource);
            this.listener.addedResourceReference(resourceReference);
            this.listener.referencesChanged();
        }
        return added;
    }

    private void check(Object source, Object registryLock) {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        if (!(source instanceof ResourceProviderService)) {
            throw new IllegalStateException("not supportecd source for changing");
        }
        Object validLock = this.getLock(source);
        if (validLock != registryLock) {
            LOG.info("invalid lock used to modify resources: {} <> {}", validLock, registryLock);
            throw new IllegalStateException("invalid lock used to modify resources");
        }
    }

    private Object getLock(Object source) {
        Object lock = this.serviceLockMap.get(source);
        if (lock == null && source instanceof ResourceProviderService) {
            lock = this.serviceLockMap.get(((ResourceProviderService)source).getServiceReference());
        }
        return lock;
    }

    private ResourceReferenceFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private synchronized <S extends Resource> boolean removeResource(Object source, Object registryLock, S resource) {
        if (this.destroyed) {
            return false;
        }
        this.check(source, registryLock);
        if (ResourcesUtil.ignore(resource)) {
            return false;
        }
        ResourceReference resourceReference = resource.getReference();
        if (ResourcesUtil.ignore((ResourceReferenceParameter)resourceReference)) {
            return false;
        }
        boolean removed = this.listener.removeResourceReference(resourceReference);
        if (removed) {
            this.resourceManagerModel.remove(resource.getReference());
            this.listener.removedResourceReference(resourceReference);
            this.listener.referencesChanged();
        }
        return removed;
    }

    private synchronized <T extends ResourceReference> boolean removeResourceReference(Object source, Object registryLock, T resourceReference) {
        if (this.destroyed) {
            return false;
        }
        this.check(source, registryLock);
        if (ResourcesUtil.ignore(resourceReference)) {
            return false;
        }
        boolean removed = this.listener.removeResourceReference(resourceReference);
        if (removed) {
            this.resourceManagerModel.remove(resourceReference);
            this.listener.removedResourceReference(resourceReference);
            this.listener.referencesChanged();
        }
        return removed;
    }

    @Override
    public synchronized void startManager() {
        if (this.destroyed) {
            return;
        }
        this.started = true;
        boolean startSuccessful = true;
        HashMap<ResourceProviderService, Object> startedServicesLockMap = new HashMap<ResourceProviderService, Object>();
        for (ResourceProviderService resourceProviderService : this.services) {
            Object registryLock = new Object();
            try {
                this.serviceLockMap.put(resourceProviderService.getServiceReference(), registryLock);
                if (!resourceProviderService.startService(registryLock, this.resourceManagerRegistryAdapter)) {
                    startSuccessful = false;
                    break;
                }
                startedServicesLockMap.put(resourceProviderService, registryLock);
            }
            catch (Exception e1) {
                startSuccessful = false;
                try {
                    resourceProviderService.stopService(registryLock);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Map.Entry resourceProviderServiceEntry : startedServicesLockMap.entrySet()) {
                    try {
                        ((ResourceProviderService)resourceProviderServiceEntry.getKey()).stopService(resourceProviderServiceEntry.getValue());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (startSuccessful) {
            for (Map.Entry entry : startedServicesLockMap.entrySet()) {
                ResourceProviderService resourceProviderService = (ResourceProviderService)entry.getKey();
                this.startedServices.add(resourceProviderService);
            }
        } else {
            if (!startedServicesLockMap.entrySet().isEmpty()) {
                for (Map.Entry entry : startedServicesLockMap.entrySet()) {
                    try {
                        ((ResourceProviderService)entry.getKey()).stopService(entry.getValue());
                    }
                    catch (Exception exception) {}
                }
            }
            this.resourceManagerModel.clear();
            this.startedServices.clear();
            this.serviceLockMap.clear();
        }
        this.started = startSuccessful;
    }

    @Override
    public synchronized void stopManager() {
        if (this.destroyed) {
            return;
        }
        for (ResourceProviderService resourceProviderService : this.startedServices) {
            Object registryLock = this.getLock(resourceProviderService);
            if (!resourceProviderService.isStarted()) continue;
            try {
                resourceProviderService.stopService(registryLock);
            }
            catch (Exception exception) {}
        }
        this.started = false;
    }

    @Override
    public synchronized <S extends ResourceProviderService> StatefulResourceManager setServices(Iterable<S> services) {
        if (this.destroyed) {
            return this;
        }
        boolean wasStarted = this.started;
        if (this.started) {
            this.stopManager();
        }
        this.services.clear();
        if (services != null) {
            for (ResourceProviderService service : services) {
                this.services.add(service);
            }
        }
        if (wasStarted) {
            this.startManager();
        }
        return this;
    }

    @Override
    public synchronized StatefulResourceManager setChangeListener(ResourceReferenceChangeListener listener) {
        if (this.destroyed) {
            return this;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("manager started");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        if (!listener.connect(this)) {
            throw new IllegalStateException("current listener can not be connected");
        }
        if (!this.listener.disconnect(this)) {
            throw new IllegalStateException("current listener can not be disconnected");
        }
        this.listener = listener;
        return this;
    }

    @Override
    public synchronized StatefulResourceManager setFilter(ResourceReferenceFilter filter) {
        if (this.destroyed) {
            return this;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("manager started");
        }
        this.filter = filter;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulResourceManager.ServiceResult stopService(ServiceResourceReference serviceResourceReference) {
        if (this.destroyed) {
            return StatefulResourceManager.ServiceResult.DESTROYED;
        }
        if (serviceResourceReference == null) {
            return StatefulResourceManager.ServiceResult.IGNORED;
        }
        if (!serviceResourceReference.getServiceState().isStarted()) {
            return StatefulResourceManager.ServiceResult.STOPPED_ALREADY;
        }
        Set<Resource> allocateResources = null;
        try {
            allocateResources = this.allocateResources(Collections.singleton(serviceResourceReference));
            if (allocateResources.isEmpty()) {
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.NOT_FOUND;
                return serviceResult;
            }
            Resource objectService = allocateResources.iterator().next();
            if (objectService == null) {
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.NOT_FOUND;
                return serviceResult;
            }
            if (objectService instanceof ResourceProviderService) {
                ResourceProviderService resourceProviderService = (ResourceProviderService)objectService;
                resourceProviderService.stopService(this.serviceLockMap.get(resourceProviderService.getServiceReference()));
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.STOPPED;
                return serviceResult;
            }
            StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.STOP_FAILED;
            return serviceResult;
        }
        finally {
            if (allocateResources != null && !allocateResources.isEmpty()) {
                this.releaseResources(allocateResources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulResourceManager.ServiceResult startService(ServiceResourceReference serviceResourceReference) {
        if (this.destroyed) {
            return StatefulResourceManager.ServiceResult.DESTROYED;
        }
        if (serviceResourceReference == null) {
            return StatefulResourceManager.ServiceResult.IGNORED;
        }
        if (serviceResourceReference.getServiceState().isStarted()) {
            return StatefulResourceManager.ServiceResult.STARTED_ALREADY;
        }
        Set<Resource> allocateResources = null;
        try {
            ResourceProviderService resourceProviderService;
            allocateResources = this.allocateResources(Collections.singleton(serviceResourceReference));
            if (allocateResources.isEmpty()) {
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.NOT_FOUND;
                return serviceResult;
            }
            Resource objectService = allocateResources.iterator().next();
            if (objectService == null) {
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.NOT_FOUND;
                return serviceResult;
            }
            if (objectService instanceof ResourceProviderService && (resourceProviderService = (ResourceProviderService)objectService).startService(this.serviceLockMap.get(resourceProviderService.getServiceReference()), this.resourceManagerRegistryAdapter)) {
                StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.STARTED;
                return serviceResult;
            }
            StatefulResourceManager.ServiceResult serviceResult = StatefulResourceManager.ServiceResult.START_FAILED;
            return serviceResult;
        }
        finally {
            if (allocateResources != null && !allocateResources.isEmpty()) {
                this.releaseResources(allocateResources);
            }
        }
    }

    @Override
    public <C extends Configuration<?>> boolean configureServices(C configuration) {
        if (this.destroyed) {
            return false;
        }
        return this.configureServices(ResourceReferenceFilter.ALL_CONFIGURABLE_SERVICES, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Configuration<?>> boolean configureServices(ResourceReferenceFilter filter, C configuration) {
        if (this.destroyed) {
            return false;
        }
        LOG.debug("resource manager configure: {}, {}", (Object)filter, configuration);
        if (configuration == null || configuration.getInfo() == null) {
            return false;
        }
        ResourceReferenceFilter infoFilter = resourceReference -> ((ServiceResourceReference)resourceReference).getConfigurationInfo().contains(configuration.getInfo());
        ResourceReferenceFilter lFilter = filter == ResourceReferenceFilter.ALL_CONFIGURABLE_SERVICES || filter == null ? ResourceReferenceFilter.ALL_CONFIGURABLE_SERVICES.and(infoFilter) : ResourceReferenceFilter.ALL_CONFIGURABLE_SERVICES.and(filter).and(infoFilter);
        Set<ResourceReferenceParameter> serviceResourceReferences = null;
        StatefulResourceManagerImpl statefulResourceManagerImpl = this;
        synchronized (statefulResourceManagerImpl) {
            serviceResourceReferences = this.resourceManagerModel.keySet().stream().filter(lFilter::accept).map(k -> k).collect(Collectors.toSet());
        }
        if (serviceResourceReferences == null || serviceResourceReferences.isEmpty()) {
            LOG.debug("resource manager configure: no services to configure");
            return false;
        }
        LOG.debug("resource manager configure: {} services to configure", (Object)serviceResourceReferences.size());
        boolean configurationSuccessful = true;
        Set<Resource> allocatedResources = null;
        try {
            allocatedResources = this.allocateResources(serviceResourceReferences);
            for (Resource resource : allocatedResources) {
                if (!(resource instanceof ServiceResource)) continue;
                ServiceResourceReference serviceReference = ((ServiceResource)resource).getServiceReference();
                try {
                    Object lock = this.serviceLockMap.get(serviceReference);
                    LOG.debug("configuring service: {}", (Object)serviceReference.getName());
                    configurationSuccessful &= ((ServiceResource)resource).configure(lock, configuration);
                }
                catch (Throwable t) {
                    LOG.error("configuring service {} failed: {}", (Object)serviceReference.getName(), (Object)t.getMessage());
                    configurationSuccessful = false;
                }
            }
        }
        finally {
            if (allocatedResources != null && !allocatedResources.isEmpty()) {
                this.releaseResources(allocatedResources);
            }
        }
        return configurationSuccessful;
    }

    @Override
    public void refresh() {
        if (this.destroyed) {
            return;
        }
        this.refresh(ResourceReferenceFilter.ALL_REFRESHABLE_SERVICES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(ResourceReferenceFilter filter) {
        if (this.destroyed) {
            return;
        }
        LOG.debug("resource manager refresh: {}", (Object)filter);
        ResourceReferenceFilter lFilter = filter == ResourceReferenceFilter.ALL_REFRESHABLE_SERVICES || filter == null ? ResourceReferenceFilter.ALL_REFRESHABLE_SERVICES : ResourceReferenceFilter.ALL_REFRESHABLE_SERVICES.and(filter);
        Set<ResourceReferenceParameter> serviceResourceReferences = null;
        StatefulResourceManagerImpl statefulResourceManagerImpl = this;
        synchronized (statefulResourceManagerImpl) {
            serviceResourceReferences = this.resourceManagerModel.keySet().stream().filter(lFilter::accept).map(k -> k).collect(Collectors.toSet());
        }
        if (serviceResourceReferences == null || serviceResourceReferences.isEmpty()) {
            LOG.debug("resource manager refresh: no services to refresh");
            return;
        }
        LOG.debug("resource manager refresh: {} services to refresh", (Object)serviceResourceReferences.size());
        Set<Resource> allocatedResources = null;
        try {
            allocatedResources = this.allocateResources(serviceResourceReferences);
            for (Resource resource : allocatedResources) {
                if (!(resource instanceof ServiceResource)) continue;
                ServiceResourceReference serviceReference = ((ServiceResource)resource).getServiceReference();
                try {
                    Object lock = this.serviceLockMap.get(serviceReference);
                    LOG.debug("refreshing service: {}", (Object)serviceReference.getName());
                    ((ServiceResource)resource).refresh(lock);
                }
                catch (Throwable t) {
                    LOG.error("refreshing service {} failed: {}", (Object)serviceReference.getName(), (Object)t.getMessage());
                }
            }
        }
        finally {
            if (allocatedResources != null && !allocatedResources.isEmpty()) {
                this.releaseResources(allocatedResources);
            }
        }
    }

    @Override
    public Map<String, String> getNameIDs() {
        return this.resourceManagerModel.getNameIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownManager() {
        Class<StatefulResourceManagerImpl> clazz = StatefulResourceManagerImpl.class;
        synchronized (StatefulResourceManagerImpl.class) {
            this.stopManager();
            if (this.resourceManagerModel instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.resourceManagerModel)).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.resourceManagerModel = null;
            this.listener = null;
            this.filter = null;
            this.serviceLockMap.clear();
            this.serviceLockMap = null;
            this.startedServices.clear();
            this.startedServices = null;
            this.services.clear();
            this.services = null;
            this.started = false;
            this.destroyed = true;
            this.resourceManagerRegistryAdapter = null;
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

