/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.management.ResourceReferenceFilter;
import java.util.Collection;

public interface ResourceRegistry {
    default public <S extends Resource> boolean addResource(Object source, Object registryLock, Collection<S> resources) {
        if (resources == null || resources.isEmpty()) {
            return true;
        }
        boolean result = true;
        for (Resource resource : resources) {
            result |= this.addResource(source, registryLock, resource);
        }
        return result;
    }

    public <S extends Resource> boolean addResource(Object var1, Object var2, S var3);

    default public <T extends ResourceReference> boolean removeResourceReference(Object source, Object registryLock, Collection<T> resourceReferences) {
        if (resourceReferences == null || resourceReferences.isEmpty()) {
            return true;
        }
        boolean result = true;
        for (ResourceReference resourceReference : resourceReferences) {
            result |= this.removeResourceReference(source, registryLock, resourceReference);
        }
        return result;
    }

    public <T extends ResourceReference> boolean removeResourceReference(Object var1, Object var2, T var3);

    @Deprecated
    default public <S extends Resource> boolean removeResource(Object source, Object registryLock, Collection<S> resources) {
        if (resources == null || resources.isEmpty()) {
            return true;
        }
        boolean result = true;
        for (Resource resource : resources) {
            result |= this.removeResource(source, registryLock, resource);
        }
        return result;
    }

    @Deprecated
    public <S extends Resource> boolean removeResource(Object var1, Object var2, S var3);

    public ResourceReferenceFilter getFilter();
}

