/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ServiceResourceReference;

@FunctionalInterface
public interface ResourceReferenceFilter {
    public static final ResourceReferenceFilter ALL = resourceReference -> true;
    public static final ResourceReferenceFilter NONE = resourceReference -> false;
    public static final ResourceReferenceFilter ALL_CONFIGURABLE_SERVICES = resourceReference -> resourceReference instanceof ServiceResourceReference && ((ServiceResourceReference)resourceReference).isConfigurable();
    public static final ResourceReferenceFilter ALL_REFRESHABLE_SERVICES = resourceReference -> resourceReference instanceof ServiceResourceReference && ((ServiceResourceReference)resourceReference).isRefreshable();
    public static final ResourceReferenceFilter DEFAULT = ALL;

    public boolean accept(ResourceReferenceParameter var1);

    default public ResourceReferenceFilter and(ResourceReferenceFilter filter1, ResourceReferenceFilter filter2) {
        return resourceReferenceParameter -> filter1.accept(resourceReferenceParameter) && (filter2 == null || filter2.accept(resourceReferenceParameter));
    }

    default public ResourceReferenceFilter and(ResourceReferenceFilter filter) {
        return resourceReferenceParameter -> this.accept(resourceReferenceParameter) && (filter == null || filter.accept(resourceReferenceParameter));
    }

    default public ResourceReferenceFilter not(ResourceReferenceFilter filter) {
        return resourceReferenceParameter -> filter != null && !filter.accept(resourceReferenceParameter);
    }

    default public ResourceReferenceFilter not() {
        return resourceReferenceParameter -> !this.accept(resourceReferenceParameter);
    }

    default public ResourceReferenceFilter or(ResourceReferenceFilter filter1, ResourceReferenceFilter filter2) {
        return resourceReferenceParameter -> filter1.accept(resourceReferenceParameter) || filter2 == null || filter2.accept(resourceReferenceParameter);
    }

    default public ResourceReferenceFilter or(ResourceReferenceFilter filter) {
        return resourceReferenceParameter -> this.accept(resourceReferenceParameter) || filter == null || filter.accept(resourceReferenceParameter);
    }
}

