/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.AbstractResourceManager;
import de.governikus.csl.uom.res.management.ResourceManagerModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ResourceManagerImpl
extends AbstractResourceManager {
    private static ResourceManagerImpl instance = null;

    public static synchronized ResourceManagerImpl getInstance() {
        if (instance == null) {
            instance = new ResourceManagerImpl();
        }
        return instance;
    }

    public static synchronized ResourceManagerImpl getInstance(ResourceManagerModel model) {
        if (instance == null) {
            instance = new ResourceManagerImpl(model);
        }
        return instance;
    }

    public ResourceManagerImpl() throws IllegalArgumentException {
    }

    public ResourceManagerImpl(ResourceManagerModel model) {
        super(model);
    }

    public ResourceManagerImpl setResources(Resource ... resources) {
        if (resources == null || resources.length == 0) {
            return this;
        }
        return this.setResources(new HashSet<Resource>(Arrays.asList(resources)));
    }

    public synchronized <T extends Resource> ResourceManagerImpl setResources(Collection<T> resources) {
        if (resources != null) {
            this.resourceManagerModel.clear();
            if (!resources.isEmpty()) {
                for (Resource resource : resources) {
                    if (resource == null || resource == ResourcesUtil.NO_RESOURCE_FOUND || resource == ResourcesUtil.NO_RESOURCE_SPECIFIED) continue;
                    this.resourceManagerModel.put(resource.getReference(), resource);
                }
            }
        }
        return this;
    }

    public synchronized void removeResources() {
        this.resourceManagerModel.clear();
    }

    @Override
    public Map<String, String> getNameIDs() {
        return this.resourceManagerModel.getNameIDs();
    }
}

