/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.ResourceReferenceFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ResourceManager {
    public Resource allocateResource(Set<ResourceReferenceParameter> var1) throws CoreException;

    default public Resource allocateResourceByRefs(List<String> resourceReferencesRefs) throws CoreException {
        if (resourceReferencesRefs == null || resourceReferencesRefs.isEmpty()) {
            return ResourcesUtil.NO_RESOURCE_SPECIFIED;
        }
        Set<ResourceReferenceParameter> resourceReferences = this.getResourceReferencesByRefs(resourceReferencesRefs);
        if (resourceReferences == ResourcesUtil.NO_RESOURCE_REFERENCE_RESOLVED_SET) {
            return ResourcesUtil.NO_RESOURCE_RESOLVED;
        }
        return this.allocateResource(resourceReferences);
    }

    public Set<Resource> allocateResources(Set<ResourceReferenceParameter> var1) throws CoreException;

    default public Set<Resource> allocateResourcesByRefs(List<String> resourceReferencesRefs) throws CoreException {
        if (resourceReferencesRefs == null || resourceReferencesRefs.isEmpty()) {
            return ResourcesUtil.NO_RESOURCE_SPECIFIED_SET;
        }
        Set<ResourceReferenceParameter> resourceReferences = this.getResourceReferencesByRefs(resourceReferencesRefs);
        if (ResourcesUtil.NO_RESOURCE_REFERENCE_RESOLVED_SET == resourceReferences) {
            return ResourcesUtil.NO_RESOURCE_RESOLVED_SET;
        }
        if (ResourcesUtil.NO_RESOURCE_REFERENCE_FOUND_SET == resourceReferences) {
            return ResourcesUtil.NO_RESOURCE_FOUND_SET;
        }
        return this.allocateResources(resourceReferences);
    }

    public boolean isEmpty();

    public int size();

    default public Set<ResourceReferenceParameter> toSetResourceReferenceParameter(Set<? extends ResourceReferenceParameter> resourceReferences) {
        return resourceReferences;
    }

    default public void releaseResource(Resource resource) {
        if (resource == null || resource == ResourcesUtil.NO_RESOURCE_FOUND || resource == ResourcesUtil.NO_RESOURCE_SPECIFIED) {
            return;
        }
        this.releaseResources(Collections.singleton(resource));
    }

    public void releaseResources(Set<Resource> var1);

    default public Set<ResourceReference> getResourceReferences() {
        return this.getResourceReferences(ResourceReferenceFilter.ALL);
    }

    public Set<ResourceReference> getResourceReferences(ResourceReferenceFilter var1);

    default public Set<ResourceReferenceParameter> getResourceReferencesByRefs(List<String> resourceReferencesRefs) {
        if (resourceReferencesRefs == null || resourceReferencesRefs.isEmpty()) {
            return this.toSetResourceReferenceParameter(ResourcesUtil.NO_RESOURCE_SPECIFIED_SET);
        }
        ArrayList<String> ids = new ArrayList<String>();
        Map<String, String> nameIDs = this.getNameIDs();
        Collection<String> knownIds = nameIDs.values();
        Set<String> knownNames = nameIDs.keySet();
        for (String resourceReferencesRef : resourceReferencesRefs) {
            if (knownIds.contains(resourceReferencesRef)) {
                ids.add(resourceReferencesRef);
                continue;
            }
            if (!knownNames.contains(resourceReferencesRef)) continue;
            ids.add(nameIDs.get(resourceReferencesRef));
        }
        if (ids.isEmpty()) {
            return this.toSetResourceReferenceParameter(ResourcesUtil.NO_RESOURCE_REFERENCE_RESOLVED_SET);
        }
        Set<ResourceReference> resourceReferences = this.getResourceReferences(r -> ids.contains(r.getId()));
        if (ResourcesUtil.ignore(resourceReferences)) {
            return this.toSetResourceReferenceParameter(ResourcesUtil.NO_RESOURCE_FOUND_SET);
        }
        return this.toSetResourceReferenceParameter(resourceReferences);
    }

    public Map<ResourceReference, Resource> getResources();

    default public Map<String, String> getNameIDs() {
        return Collections.emptyMap();
    }
}

