/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.ServiceResourceReference;
import de.governikus.csl.uom.res.ServiceResourceReferenceState;
import de.governikus.csl.uom.res.management.ResourceProviderService;
import de.governikus.csl.uom.res.management.ResourceRegistry;
import de.governikus.csl.uom.service.AbstractService;
import de.governikus.csl.uom.types.Configuration;
import de.governikus.csl.uom.types.ConfigurationInfo;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyResourceProviderService
extends AbstractService
implements ResourceProviderService {
    private static final Logger LOG = Logger.getLogger(ProxyResourceProviderService.class.getName());
    protected ResourceProviderService delegationService;

    @Override
    public String getName() {
        return this.delegationService.getName();
    }

    @Override
    public String getID() {
        return this.delegationService.getID();
    }

    @Override
    public final synchronized boolean startService(Object registryLock, ResourceRegistry registry) {
        this.started = this.enabled ? this.delegationService.startService(registryLock, registry) : true;
        return this.started;
    }

    @Override
    public final synchronized void stopService(Object registryLock) {
        if (this.enabled) {
            this.delegationService.stopService(registryLock);
            return;
        }
        this.started = false;
    }

    @Override
    public final boolean isStarted() {
        if (this.enabled) {
            return this.delegationService.isStarted();
        }
        return this.started;
    }

    public int hashCode() {
        return this.delegationService.hashCode();
    }

    public final boolean equals(Object obj) {
        return this.delegationService.equals(obj);
    }

    public final String toString() {
        return super.toString() + "[" + this.delegationService.toString() + "]";
    }

    public ProxyResourceProviderService(ResourceProviderService service) {
        super("proxy", Objects.requireNonNull(service, "service is required").getClass());
        this.setService(service);
    }

    private final synchronized ProxyResourceProviderService setService(ResourceProviderService newDelegationService) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("set service: %1s", newDelegationService.getName()));
        }
        Objects.requireNonNull(newDelegationService, "service to delegate to can not be null");
        this.delegationService = newDelegationService;
        this.setEnabledInt(this.enabled);
        this.name = this.delegationService.getID();
        this.id = this.delegationService.getName();
        return this;
    }

    @Override
    protected boolean setEnabledInt(boolean enabled) {
        if (this.delegationService != null) {
            if (this.delegationService.isStarted()) {
                try {
                    this.delegationService.stopService(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.delegationService.setEnabled(enabled);
        }
        return true;
    }

    @Override
    public void setManagerService(InstanceProvider instanceProvider) {
        this.delegationService.setManagerService(instanceProvider);
    }

    public ResourceReference getReference() {
        return this.delegationService.getReference();
    }

    public ServiceResourceReference getServiceReference() {
        return this.delegationService.getServiceReference();
    }

    public ResourceState getState() {
        return this.delegationService.getState();
    }

    public boolean isPresent() {
        return this.delegationService.isPresent();
    }

    public boolean isAbsent() {
        return this.delegationService.isAbsent();
    }

    @Override
    public LockState getLockState() {
        return this.delegationService.getLockState();
    }

    @Override
    public void setLockState(LockState lockState) {
        this.delegationService.setLockState(lockState);
    }

    public boolean isRefreshable() {
        return this.delegationService.isRefreshable();
    }

    public void refresh(Object lock) throws CoreException {
        this.delegationService.refresh(lock);
    }

    public boolean isConfigurable() {
        return this.delegationService.isConfigurable();
    }

    public <C extends Configuration<?>> boolean configure(Object lock, C configuration) {
        return this.delegationService.configure(lock, configuration);
    }

    public List<? extends ConfigurationInfo> getConfigurationInfo() {
        return this.delegationService.getConfigurationInfo();
    }

    @Override
    public ServiceResourceReferenceState getServiceState() {
        return this.getServiceReference().getServiceState();
    }
}

