/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.AbstractResourceManagerModel;
import java.util.HashSet;
import java.util.Set;

public class DefaultResourceManagerModelImpl
extends AbstractResourceManagerModel {
    @Override
    public final Resource allocateResource(Set<ResourceReferenceParameter> resourceReferences) throws CoreException {
        if (this.closed) {
            return ResourcesUtil.NO_RESOURCE_FOUND;
        }
        if (ResourcesUtil.ignore(resourceReferences)) {
            return ResourcesUtil.NO_RESOURCE_SPECIFIED;
        }
        for (ResourceReferenceParameter resourceReference : resourceReferences) {
            if (this.closed) {
                return ResourcesUtil.NO_RESOURCE_FOUND;
            }
            if (ResourcesUtil.ignore(resourceReference)) continue;
            Resource foundResource = ResourcesUtil.findResource(this.resources, resourceReference);
            if (this.closed || ResourcesUtil.ignore((ResourceReferenceParameter)foundResource)) continue;
            return foundResource;
        }
        return ResourcesUtil.NO_RESOURCE_FOUND;
    }

    @Override
    public final Set<Resource> allocateResources(Set<ResourceReferenceParameter> resourceReferences) {
        if (this.closed) {
            return ResourcesUtil.NO_RESOURCE_FOUND_SET;
        }
        if (ResourcesUtil.ignore(resourceReferences)) {
            return ResourcesUtil.NO_RESOURCE_SPECIFIED_SET;
        }
        HashSet<Resource> foundResources = new HashSet<Resource>();
        for (ResourceReferenceParameter resourceReference : resourceReferences) {
            if (this.closed) {
                return ResourcesUtil.NO_RESOURCE_FOUND_SET;
            }
            if (ResourcesUtil.ignore(resourceReference)) continue;
            Resource found = ResourcesUtil.findResource(this.resources, resourceReference);
            if (this.closed || ResourcesUtil.ignore((ResourceReferenceParameter)found)) continue;
            foundResources.add(found);
        }
        if (foundResources.isEmpty()) {
            return ResourcesUtil.NO_RESOURCE_FOUND_SET;
        }
        return foundResources;
    }

    @Override
    public final void releaseResources(Set<Resource> resources) {
    }
}

