/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.ResourceManagerModel;
import de.governikus.csl.uom.res.management.ResourceReferenceFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractResourceManagerModel
implements ResourceManagerModel,
Closeable {
    protected boolean closed = false;
    protected Map<String, String> namesIds;
    protected Map<ResourceReference, Resource> resources = new HashMap<ResourceReference, Resource>();
    protected Map<String, String> unmodfiableNamesIds;
    protected Set<ResourceReference> unmodifiableResourceReferencesSet;
    protected Map<ResourceReference, Resource> unmodifiableResources;
    protected Collection<Resource> unmodifiableResourcesValues;

    public AbstractResourceManagerModel() {
        this.namesIds = new HashMap<String, String>();
        this.unmodifiableResourceReferencesSet = Collections.unmodifiableSet(this.resources.keySet());
        this.unmodifiableResources = Collections.unmodifiableMap(this.resources);
        this.unmodfiableNamesIds = Collections.unmodifiableMap(this.namesIds);
        this.unmodifiableResourcesValues = Collections.unmodifiableCollection(this.resources.values());
    }

    @Override
    public synchronized void clear() {
        if (this.closed) {
            return;
        }
        this.resources.clear();
        this.namesIds.clear();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.resources.clear();
        this.resources = null;
        this.namesIds.clear();
        this.namesIds = null;
        this.unmodifiableResourceReferencesSet = null;
        this.unmodifiableResources = null;
        this.unmodifiableResourcesValues = null;
        this.unmodfiableNamesIds = null;
    }

    @Override
    public final Map<String, String> getNameIDs() {
        return this.closed ? Collections.emptyMap() : this.unmodfiableNamesIds;
    }

    @Override
    public final Set<ResourceReference> getResourceReferences() {
        return this.closed ? Collections.emptySet() : this.unmodifiableResourceReferencesSet;
    }

    @Override
    public final Set<ResourceReference> getResourceReferences(ResourceReferenceFilter filter) {
        if (this.closed) {
            return Collections.emptySet();
        }
        if (filter == null || ResourceReferenceFilter.ALL == filter) {
            return this.unmodifiableResourceReferencesSet;
        }
        return Collections.unmodifiableSet(this.unmodifiableResourceReferencesSet.stream().filter(filter::accept).collect(Collectors.toSet()));
    }

    @Override
    public final Map<ResourceReference, Resource> getResources() {
        return this.closed ? Collections.emptyMap() : this.unmodifiableResources;
    }

    @Override
    public final boolean isEmpty() {
        return this.closed ? Boolean.TRUE.booleanValue() : this.resources.isEmpty();
    }

    @Override
    public final Set<ResourceReference> keySet() {
        return this.closed ? Collections.emptySet() : this.unmodifiableResourceReferencesSet;
    }

    @Override
    public final ResourceManagerModel put(ResourceReference reference, Resource resource) {
        if (this.closed || ResourcesUtil.ignore((ResourceReferenceParameter)reference) || ResourcesUtil.ignore((ResourceReferenceParameter)resource)) {
            return this;
        }
        this.resources.put(reference, resource);
        this.namesIds.put(reference.getName(), reference.getId());
        return this;
    }

    @Override
    public void remove(ResourceReference reference) {
        if (this.closed || ResourcesUtil.ignore((ResourceReferenceParameter)reference)) {
            return;
        }
        this.resources.remove(reference);
        this.namesIds.remove(reference.getName());
    }

    @Override
    public final int size() {
        return this.closed ? 0 : this.resources.size();
    }

    @Override
    public final Collection<Resource> values() {
        return this.closed ? Collections.emptySet() : this.unmodifiableResourcesValues;
    }
}

