/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.DefaultResourceManagerModelImpl;
import de.governikus.csl.uom.res.management.ResourceManager;
import de.governikus.csl.uom.res.management.ResourceManagerModel;
import de.governikus.csl.uom.res.management.ResourceReferenceFilter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class AbstractResourceManager
implements ResourceManager {
    protected ResourceManagerModel resourceManagerModel;

    public AbstractResourceManager() {
        this.resourceManagerModel = new DefaultResourceManagerModelImpl();
    }

    public AbstractResourceManager(ResourceManagerModel model) {
        if (model == null) {
            throw new IllegalArgumentException("missing required model");
        }
        this.resourceManagerModel = model;
    }

    @Override
    public final Set<Resource> allocateResources(Set<ResourceReferenceParameter> resourceReferences) {
        if (resourceReferences == null || resourceReferences.isEmpty()) {
            return ResourcesUtil.NO_RESOURCE_SPECIFIED_SET;
        }
        try {
            return this.resourceManagerModel.allocateResources(resourceReferences);
        }
        catch (CoreException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public final void releaseResources(Set<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        this.resourceManagerModel.releaseResources(resources);
    }

    @Override
    public final Set<ResourceReference> getResourceReferences() {
        return this.resourceManagerModel.getResourceReferences();
    }

    @Override
    public Set<ResourceReference> getResourceReferences(ResourceReferenceFilter filter) {
        return this.resourceManagerModel.getResourceReferences(filter);
    }

    @Override
    public final boolean isEmpty() {
        return this.resourceManagerModel.isEmpty();
    }

    @Override
    public final int size() {
        return this.resourceManagerModel.size();
    }

    @Override
    public final Map<ResourceReference, Resource> getResources() {
        return this.resourceManagerModel.getResources();
    }

    @Override
    public final Resource allocateResource(Set<ResourceReferenceParameter> resourceReferences) throws CoreException {
        return this.resourceManagerModel.allocateResource(resourceReferences);
    }

    @Override
    public final void releaseResource(Resource resource) {
        this.resourceManagerModel.releaseResource(resource);
    }
}

