/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.decrypt.DecryptOptions;
import de.governikus.csl.uom.decrypt.DecryptRequest;
import de.governikus.csl.uom.res.AbstractResourceReference;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.res.TrustedAnchorServiceResource;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoBuilder;
import de.governikus.csl.uom.sign.props.CertificateValues;
import de.governikus.csl.uom.sign.props.ContentTimestamp;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.RevocationValues;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.uom.sign.props.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ResourcesUtil {
    public static final ResourceReference NO_RESOURCE_SPECIFIED_REFERENCE = new ResourceReference(){

        public String getName() {
            return "NO_RESOURCE_SPECIFIED_REFERENCE";
        }

        public String getResourceType() {
            return null;
        }

        public ResourceType getType() {
            return null;
        }

        public ResourceComponentType getComponentType() {
            return null;
        }

        public ResourceAreaType getAreaType() {
            return null;
        }

        public ResourceReference getOriginatorService() {
            return null;
        }

        public ResourceReferenceState getState() {
            return null;
        }
    };
    public static final Resource NO_RESOURCE_SPECIFIED = new Resource(){

        public String getName() {
            return this.getReference().getName();
        }

        public ResourceReference getReference() {
            return NO_RESOURCE_SPECIFIED_REFERENCE;
        }

        public ResourceState getState() {
            return null;
        }
    };
    public static final ResourceReference NO_RESOURCE_FOUND_REFERENCE = new ResourceReference(){

        public String getName() {
            return "NO_RESOURCE_FOUND_REFERENCE";
        }

        public String getResourceType() {
            return null;
        }

        public ResourceType getType() {
            return null;
        }

        public ResourceComponentType getComponentType() {
            return null;
        }

        public ResourceAreaType getAreaType() {
            return null;
        }

        public ResourceReference getOriginatorService() {
            return null;
        }

        public ResourceReferenceState getState() {
            return null;
        }
    };
    public static final Resource NO_RESOURCE_FOUND = new Resource(){

        public String getName() {
            return this.getReference().getName();
        }

        public ResourceReference getReference() {
            return NO_RESOURCE_FOUND_REFERENCE;
        }

        public ResourceState getState() {
            return null;
        }
    };
    public static final ResourceReference NO_RESOURCE_RESOLVED_REFERENCE = new ResourceReference(){

        public String getName() {
            return "NO_RESOURCE_RESOLVED_REFERENCE";
        }

        public String getResourceType() {
            return null;
        }

        public ResourceType getType() {
            return null;
        }

        public ResourceComponentType getComponentType() {
            return null;
        }

        public ResourceAreaType getAreaType() {
            return null;
        }

        public ResourceReference getOriginatorService() {
            return null;
        }

        public ResourceReferenceState getState() {
            return null;
        }
    };
    public static final Resource NO_RESOURCE_RESOLVED = new Resource(){

        public String getName() {
            return this.getReference().getName();
        }

        public ResourceReference getReference() {
            return NO_RESOURCE_RESOLVED_REFERENCE;
        }

        public ResourceState getState() {
            return null;
        }
    };
    public static final Set<Resource> NO_RESOURCE_SPECIFIED_SET = Collections.unmodifiableSet(new HashSet());
    public static final Set<ResourceReferenceParameter> NO_RESOURCE_REFERENCE_RESOLVED_SET = Collections.unmodifiableSet(new HashSet());
    public static final Set<Resource> NO_RESOURCE_RESOLVED_SET = Collections.unmodifiableSet(new HashSet());
    public static final Set<ResourceReferenceParameter> NO_RESOURCE_REFERENCE_FOUND_SET = Collections.unmodifiableSet(new HashSet());
    public static final Set<Resource> NO_RESOURCE_FOUND_SET = Collections.unmodifiableSet(new HashSet());

    private ResourcesUtil() {
    }

    public static Resource findResource(Map<ResourceReference, ? extends Resource> resources, ResourceReferenceParameter resourceReference) {
        if (resources == null || resources.isEmpty() || ResourcesUtil.ignore(resourceReference)) {
            return null;
        }
        Class resourceType = ResourceReferenceParameter.RESOURCE.getResourceClass(((ResourceReference)resourceReference).getResourceType());
        List<Resource> foundResourcesType = ResourcesUtil.findResourcesByType(resourceType, resources);
        if (foundResourcesType == null || foundResourcesType.isEmpty()) {
            return null;
        }
        Resource foundResource = null;
        for (Resource resource : foundResourcesType) {
            ResourceReference tmp = resource.getReference();
            if (!tmp.equals(resourceReference) && !AbstractResourceReference.equals((Object)tmp, (Object)resourceReference)) continue;
            foundResource = resource;
            break;
        }
        return foundResource;
    }

    public static <T extends Resource> List<T> findResourcesByType(Class<T> resourceType, Map<ResourceReference, ? extends Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Resource resource : resources.values()) {
            if (ResourcesUtil.ignore((ResourceReferenceParameter)resource) || !resourceType.isInstance(resource)) continue;
            result.add(resourceType.cast(resource));
        }
        return result;
    }

    public static boolean ignore(Set<? extends ResourceReferenceParameter> resourceReferences) {
        return resourceReferences == null || resourceReferences.isEmpty() || resourceReferences == NO_RESOURCE_REFERENCE_FOUND_SET || resourceReferences == NO_RESOURCE_REFERENCE_RESOLVED_SET || resourceReferences == NO_RESOURCE_FOUND_SET || resourceReferences == NO_RESOURCE_RESOLVED_SET || resourceReferences == NO_RESOURCE_SPECIFIED_SET;
    }

    public static boolean ignore(ResourceReferenceParameter resourceReferenceParameter) {
        if (resourceReferenceParameter == null || NO_RESOURCE_FOUND == resourceReferenceParameter || NO_RESOURCE_RESOLVED == resourceReferenceParameter || NO_RESOURCE_SPECIFIED == resourceReferenceParameter || NO_RESOURCE_FOUND_REFERENCE == resourceReferenceParameter || NO_RESOURCE_RESOLVED_REFERENCE == resourceReferenceParameter || NO_RESOURCE_SPECIFIED_REFERENCE == resourceReferenceParameter) {
            return true;
        }
        if (resourceReferenceParameter instanceof Resource) {
            return ResourcesUtil.ignore((ResourceReferenceParameter)((Resource)resourceReferenceParameter).getReference());
        }
        return false;
    }

    public static void replaceReferencesWithResources(DecryptRequest decryptRequest, Set<Resource> resources) {
        if (decryptRequest == null || resources == null || resources.isEmpty()) {
            return;
        }
        LinkedHashMap<ResourceReference, Resource> mapRefToResources = new LinkedHashMap<ResourceReference, Resource>();
        for (Resource resource : resources) {
            mapRefToResources.put(resource.getReference(), resource);
        }
        ResourcesUtil.replaceReferencesWithResources(decryptRequest, mapRefToResources);
    }

    public static void replaceReferencesWithResources(DecryptRequest decryptRequest, Map<ResourceReference, Resource> resources) {
        if (decryptRequest == null || resources == null || resources.isEmpty()) {
            return;
        }
        ResourcesUtil.replaceReferencesWithResources((DecryptOptions)decryptRequest.getOptions(), resources);
    }

    public static void replaceReferencesWithResources(SignRequest signRequest, Set<Resource> resources) {
        if (signRequest == null || resources == null || resources.isEmpty()) {
            return;
        }
        LinkedHashMap<ResourceReference, Resource> mapRefToResources = new LinkedHashMap<ResourceReference, Resource>();
        for (Resource resource : resources) {
            mapRefToResources.put(resource.getReference(), resource);
        }
        ResourcesUtil.replaceReferencesWithResources(signRequest, mapRefToResources);
    }

    public static void replaceReferencesWithResources(SignRequest signRequest, Map<ResourceReference, Resource> resources) {
        if (signRequest == null || resources == null || resources.isEmpty()) {
            return;
        }
        ResourcesUtil.replaceReferencesWithResources((SignOptions)signRequest.getOptions(), resources);
    }

    public static void replaceReferencesWithResources(DecryptOptions signOptions, Map<ResourceReference, Resource> resources) {
        if (signOptions == null || resources == null || resources.isEmpty()) {
            return;
        }
    }

    public static void replaceReferencesWithResources(SignOptions signOptions, Map<ResourceReference, Resource> resources) {
        if (signOptions == null || resources == null || resources.isEmpty()) {
            return;
        }
        SignOptionsBuilder sob = new SignOptionsBuilder(signOptions);
        sob.setDefaultCertificateValidationService((CertificateValidationServiceResource)ResourcesUtil.findResource(signOptions.getDefaultCertificateValidationService(), resources));
        sob.setDefaultTrustedAnchorService((TrustedAnchorServiceResource)ResourcesUtil.findResource(signOptions.getDefaultTrustedAnchorService(), resources));
        sob.setDefaultTimestampService((TimestampServiceResource)ResourcesUtil.findResource(signOptions.getDefaultTimestampService(), resources));
        ResourcesUtil.replaceReferencesWithResources(signOptions.getDefaultSignerInfo(), resources);
        for (SignerInfo signerInfo : signOptions.getSignerInfos()) {
            ResourcesUtil.replaceReferencesWithResources(signerInfo, resources);
        }
    }

    public static void replaceReferencesWithResources(SignerInfo signerInfo, Map<ResourceReference, Resource> resources) {
        RevocationValues revocationValues;
        if (signerInfo == null || resources == null || resources.isEmpty()) {
            return;
        }
        SignerInfoBuilder sib = new SignerInfoBuilder(signerInfo);
        sib.setKey((PrivateKeyResourceReferenceParameter)((PrivateKeyResource)ResourcesUtil.findResource(sib.getKey(), resources)));
        SignedProperties signedProperties = signerInfo.getSignedProperties();
        ContentTimestamp contentTimestamp = PropertiesUtil.getSignedProperty(ContentTimestamp.class, signedProperties, false);
        ResourcesUtil.replaceReferencesWithResources(contentTimestamp, resources);
        UnsignedProperties unsignedProperties = signerInfo.getUnsignedProperties();
        SignatureTimestamp signatureTimestamp = PropertiesUtil.getUnsignedProperty(SignatureTimestamp.class, unsignedProperties, false);
        ResourcesUtil.replaceReferencesWithResources(signatureTimestamp, resources);
        CertificateValues certificateValues = PropertiesUtil.getUnsignedProperty(CertificateValues.class, unsignedProperties, false);
        if (certificateValues != null) {
            certificateValues.setTrustedAnchorService((TrustedAnchorServiceResource)ResourcesUtil.findResource(certificateValues.getTrustedAnchorService(), resources));
        }
        if ((revocationValues = PropertiesUtil.getUnsignedProperty(RevocationValues.class, unsignedProperties, false)) != null) {
            revocationValues.setCertificateValidationService((CertificateValidationServiceResource)ResourcesUtil.findResource(revocationValues.getCertificateValidationService(), resources));
            revocationValues.setTrustedAnchorService((TrustedAnchorServiceResource)ResourcesUtil.findResource(revocationValues.getTrustedAnchorService(), resources));
        }
    }

    public static void replaceReferencesWithResources(Timestamp timestamp, Map<ResourceReference, Resource> resources) {
        if (timestamp == null || resources == null || resources.isEmpty()) {
            return;
        }
        timestamp.setCertificateValidationService((CertificateValidationServiceResource)ResourcesUtil.findResource(timestamp.getCertificateValidationService(), resources));
        timestamp.setTrustedAnchorService((TrustedAnchorServiceResource)ResourcesUtil.findResource(timestamp.getTrustedAnchorService(), resources));
        timestamp.setTimestampService((TimestampServiceResource)ResourcesUtil.findResource(timestamp.getTimestampService(), resources));
    }

    public static <T extends ResourceReferenceParameter> Resource findResource(T resourceReferenceParameter, Map<ResourceReference, Resource> resources) {
        if (resourceReferenceParameter == null || resources == null || resources.isEmpty()) {
            return null;
        }
        Resource resource = resources.get(resourceReferenceParameter instanceof Resource ? ((Resource)resourceReferenceParameter).getReference() : resourceReferenceParameter);
        if (resource == null) {
            throw new IllegalArgumentException("no resource found for reference");
        }
        ResourceReference reference = (ResourceReference)(resourceReferenceParameter instanceof Resource ? ((Resource)resourceReferenceParameter).getReference() : resourceReferenceParameter);
        try {
            return (Resource)ResourceReferenceParameter.RESOURCE.getResourceClass(reference.getResourceType()).cast(resource);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Set<ResourceReferenceParameter> findResourceReferences(SignRequest signRequest) {
        HashSet<ResourceReferenceParameter> result = new HashSet<ResourceReferenceParameter>();
        if (signRequest == null) {
            return result;
        }
        result.addAll(ResourcesUtil.findResourceReferences((SignOptions)signRequest.getOptions()));
        result.remove(null);
        return result;
    }

    public static Set<ResourceReferenceParameter> findResourceReferences(SignOptions signOptions) {
        HashSet<ResourceReferenceParameter> result = new HashSet<ResourceReferenceParameter>();
        if (signOptions == null) {
            return result;
        }
        result.add(signOptions.getDefaultTimestampService());
        result.add(signOptions.getDefaultTrustedAnchorService());
        result.add(signOptions.getDefaultCertificateValidationService());
        result.addAll(ResourcesUtil.findResourceReferences(signOptions.getDefaultSignerInfo()));
        for (SignerInfo signerInfo : signOptions.getSignerInfos()) {
            result.addAll(ResourcesUtil.findResourceReferences(signerInfo));
        }
        result.remove(null);
        return result;
    }

    public static Set<? extends ResourceReferenceParameter> findResourceReferences(SignerInfo signerInfo) {
        RevocationValues revocationValues;
        CertificateValues certificateValues;
        UnsignedProperties unsignedProperties;
        SignatureTimestamp signatureTimestamp;
        HashSet<Object> result = new HashSet<Object>();
        if (signerInfo == null) {
            return result;
        }
        result.add(signerInfo.getKey());
        SignedProperties signedProperties = signerInfo.getSignedProperties();
        ContentTimestamp contentTimestamp = PropertiesUtil.getSignedProperty(ContentTimestamp.class, signedProperties, false);
        if (contentTimestamp != null) {
            result.addAll(ResourcesUtil.findResourceReferences(contentTimestamp));
        }
        if ((signatureTimestamp = PropertiesUtil.getUnsignedProperty(SignatureTimestamp.class, unsignedProperties = signerInfo.getUnsignedProperties(), false)) != null) {
            result.addAll(ResourcesUtil.findResourceReferences(signatureTimestamp));
        }
        if ((certificateValues = PropertiesUtil.getUnsignedProperty(CertificateValues.class, unsignedProperties, false)) != null) {
            result.add(certificateValues.getTrustedAnchorService());
        }
        if ((revocationValues = PropertiesUtil.getUnsignedProperty(RevocationValues.class, unsignedProperties, false)) != null) {
            result.add(revocationValues.getCertificateValidationService());
            result.add(revocationValues.getTrustedAnchorService());
        }
        result.remove(null);
        return result;
    }

    public static Collection<? extends ResourceReferenceParameter> findResourceReferences(Timestamp timestamp) {
        HashSet<Object> result = new HashSet<Object>();
        if (timestamp == null) {
            return result;
        }
        result.add(timestamp.getCertificateValidationService());
        result.add(timestamp.getTrustedAnchorService());
        result.add(timestamp.getTimestampService());
        result.remove(null);
        return result;
    }
}

