/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.ConfigurationListener;
import de.governikus.csl.uom.types.Configuration;
import de.governikus.csl.uom.types.ConfigurationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigurationManager {
    private Map<List<ConfigurationInfo>, ConfigurationListener> listeners;
    private Map<ConfigurationInfo, Configuration<?>> configurations = new HashMap();
    private static ConfigurationManager manager;

    private ConfigurationManager() {
        this.listeners = new HashMap<List<ConfigurationInfo>, ConfigurationListener>();
    }

    public <C> Configuration<C> get(Class<C> type, ConfigurationInfo configurationInfo) {
        Configuration<?> configuration = this.configurations.get(configurationInfo);
        if (configuration != null && type.isInstance(configuration.toObject())) {
            return configuration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        List<ConfigurationInfo> notificationsFor = listener.getNotificationsFor();
        if (notificationsFor == null || notificationsFor.isEmpty()) {
            return;
        }
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.listeners.put(notificationsFor, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.listeners.remove(listener.getNotificationsFor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Configuration<?> ... configurations) {
        if (configurations == null || configurations.length == 0) {
            return;
        }
        ArrayList<ConfigurationInfo> changes = new ArrayList<ConfigurationInfo>();
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            for (Configuration<?> configuration : configurations) {
                if (configuration == null) continue;
                ConfigurationInfo info = configuration.getInfo();
                this.configurations.put(info, configuration);
                changes.add(info);
            }
        }
        if (!changes.isEmpty()) {
            this.notifyListeners(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(List<ConfigurationInfo> changedConfigurationInfos) {
        for (ConfigurationInfo changedConfigurationInfo : changedConfigurationInfos) {
            List<ConfigurationListener> notifyListeners = this.findListener(changedConfigurationInfo);
            if (notifyListeners == null || notifyListeners.isEmpty()) continue;
            Configuration<?> configuration = null;
            ConfigurationManager configurationManager = this;
            synchronized (configurationManager) {
                configuration = this.configurations.get(changedConfigurationInfo);
            }
            for (ConfigurationListener notifyListener : notifyListeners) {
                notifyListener.update(configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfigurationListener> findListener(ConfigurationInfo changedConfigurationInfo) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return Collections.emptyList();
        }
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            return this.listeners.entrySet().stream().filter(e -> ((List)e.getKey()).contains(changedConfigurationInfo)).map(Map.Entry::getValue).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ConfigurationInfo ... configurationInfos) {
        if (configurationInfos == null || configurationInfos.length == 0) {
            return;
        }
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            for (ConfigurationInfo configurationInfo : configurationInfos) {
                if (configurationInfo == null) continue;
                this.configurations.remove(configurationInfo);
            }
        }
    }

    public synchronized void clearConfigurations() {
        this.configurations.clear();
    }

    public synchronized void clearListeners() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.clearListeners();
            this.clearConfigurations();
        }
    }

    public static synchronized ConfigurationManager getManager() {
        if (manager == null) {
            manager = new ConfigurationManager();
        }
        return manager;
    }
}

