/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.AbstractResource;
import de.governikus.csl.uom.res.CertificateValidationServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import org.bouncycastle.cert.ocsp.OCSPResp;

public abstract class CertificateValidationServiceResource
extends AbstractResource
implements CertificateValidationServiceResourceReferenceParameter,
Resource {
    public CertificateValidationServiceResource(ResourceReference resourceReference) throws IllegalArgumentException {
        super(resourceReference);
    }

    public abstract X509CRL[] getCRLs(ValidationParameters var1, Certificate ... var2);

    public abstract OCSPResp[] getOcspResponses(ValidationParameters var1, String var2, Certificate ... var3);

    public static class ValidationParameters {
        private final SecurityLevel securityLevel;
        private final ValidationMode validationMode;
        private final RevocationInformation revocationInformation;

        public ValidationParameters() {
            this(SecurityLevel.DEFAULT, ValidationMode.DEFAULT, RevocationInformation.DEFAULT);
        }

        public ValidationParameters(SecurityLevel securityLevel, ValidationMode validationMode, RevocationInformation revocationInformation) {
            this.securityLevel = securityLevel == null ? SecurityLevel.DEFAULT : securityLevel;
            this.validationMode = validationMode == null ? ValidationMode.DEFAULT : validationMode;
            this.revocationInformation = revocationInformation == null ? RevocationInformation.DEFAULT : revocationInformation;
        }

        public SecurityLevel getSecurityLevel() {
            return this.securityLevel;
        }

        public ValidationMode getValidationMode() {
            return this.validationMode;
        }

        public RevocationInformation getRevocationInformation() {
            return this.revocationInformation;
        }
    }

    public static enum ValidationMode {
        ONLINE,
        ONLINE_WITH_CACHING,
        LOCAL;

        public static final ValidationMode DEFAULT;

        static {
            DEFAULT = ONLINE_WITH_CACHING;
        }
    }

    public static enum RevocationInformation {
        NONE,
        OCSP_ONLY,
        CRL,
        ALL;

        public static final RevocationInformation DEFAULT;

        static {
            DEFAULT = ALL;
        }
    }

    public static enum SecurityLevel {
        UNSECURE,
        SECURE_NOT_VALIDATING,
        SECURE_MATH,
        SECURE;

        public static final SecurityLevel DEFAULT;

        static {
            DEFAULT = SECURE;
        }
    }
}

