/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.InternationalizedString;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.ValidityIntervall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SimplePolicyInformationImpl
implements PolicyInformation {
    private String version;
    private List<? extends InternationalizedString> description;
    private List<? extends InternationalizedString> name;
    private ValidityIntervall validityIntervall;
    private String author;
    protected static final Date UNLIMITED_VALID_FROM = new Date(0L);
    protected static final Date UNLIMITED_VALID_TO = new Date(Long.MAX_VALUE);
    public static final ValidityIntervall UNLIMITED_VALIDITY_INTERVALL = new ValidityIntervall(){

        @Override
        public Date getValidFrom() {
            return UNLIMITED_VALID_FROM;
        }

        @Override
        public Date getValidTo() {
            return UNLIMITED_VALID_TO;
        }
    };

    public SimplePolicyInformationImpl(PolicyInformation copy) {
        this.setVersion(copy.getVersion());
        this.setAuthor(copy.getAuthor());
        this.setName(copy.getName());
        this.setDescription(copy.getDescription());
        this.setValidityIntervall(copy.getValidityIntervall());
    }

    public String toString() {
        return super.toString() + "[version=" + this.version + ", author=" + this.author + ", validityIntervall=" + this.validityIntervall + ", name=" + this.name + ", description=" + this.description + "]";
    }

    public SimplePolicyInformationImpl() {
    }

    @Override
    public ValidityIntervall getValidityIntervall() {
        return this.validityIntervall;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public List<? extends InternationalizedString> getName() {
        return this.name;
    }

    @Override
    public List<? extends InternationalizedString> getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.validityIntervall == null ? 0 : this.validityIntervall.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePolicyInformationImpl other = (SimplePolicyInformationImpl)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.validityIntervall == null ? other.validityIntervall != null : !this.validityIntervall.equals(other.validityIntervall)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    void setValidityIntervall(ValidityIntervall lValidityIntervall) {
        this.validityIntervall = lValidityIntervall == null ? UNLIMITED_VALIDITY_INTERVALL : lValidityIntervall;
    }

    void setAuthor(String author) {
        this.author = this.checkString("author", author);
    }

    void setName(List<? extends InternationalizedString> name) {
        this.name = this.copy(name);
    }

    private List<? extends InternationalizedString> copy(List<? extends InternationalizedString> strings) {
        return strings == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<InternationalizedString>(strings));
    }

    void setDescription(List<? extends InternationalizedString> description) {
        this.description = this.copy(description);
    }

    void setVersion(String version) {
        this.version = this.checkString("version", version);
    }

    private String checkString(String name, String string) {
        if (string == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(name + " can not be empty");
        }
        return string;
    }
}

