/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.Builder;
import de.governikus.csl.uom.InternationalizedString;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.ValidityIntervall;
import de.governikus.csl.uom.impl.SimplePolicyInformationImpl;
import java.util.List;

public class PolicyInformationBuilder
implements Builder<PolicyInformation, SimplePolicyInformationImpl, PolicyInformationBuilder> {
    private SimplePolicyInformationImpl target;
    private boolean changed = false;

    public PolicyInformationBuilder(PolicyInformation copy) {
        this.reset(copy);
    }

    public PolicyInformationBuilder() {
        this.reset();
    }

    @Override
    public PolicyInformationBuilder reset() {
        return this.reset(null);
    }

    @Override
    public PolicyInformationBuilder reset(PolicyInformation copy) {
        this.target = copy == null ? new SimplePolicyInformationImpl() : new SimplePolicyInformationImpl(copy);
        this.changed = false;
        return this;
    }

    public PolicyInformationBuilder setAuthor(String author) {
        this.target.setAuthor(author);
        this.changed = true;
        return this;
    }

    public PolicyInformationBuilder setName(List<? extends InternationalizedString> names) {
        this.target.setName(names);
        this.changed = true;
        return this;
    }

    public PolicyInformationBuilder setDescription(List<? extends InternationalizedString> descriptions) {
        this.target.setDescription(descriptions);
        this.changed = true;
        return this;
    }

    public PolicyInformationBuilder setVersion(String version) {
        this.target.setVersion(version);
        this.changed = true;
        return this;
    }

    public PolicyInformationBuilder setValidityIntervall(ValidityIntervall validityIntervall) {
        this.target.setValidityIntervall(validityIntervall);
        this.changed = true;
        return this;
    }

    @Override
    public synchronized SimplePolicyInformationImpl build() {
        try {
            SimplePolicyInformationImpl simplePolicyInformationImpl = this.changed ? new SimplePolicyInformationImpl(this.target) : this.target;
            return simplePolicyInformationImpl;
        }
        finally {
            this.changed = false;
        }
    }

    @Override
    public synchronized SimplePolicyInformationImpl buildUnmodifiable() {
        return PolicyInformationBuilder.unmodifiable(this.build());
    }

    public static SimplePolicyInformationImpl unmodifiable(final PolicyInformation policyInformation) {
        return new SimplePolicyInformationImpl(){

            @Override
            public int hashCode() {
                return policyInformation.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return policyInformation.equals(obj);
            }

            @Override
            public ValidityIntervall getValidityIntervall() {
                return policyInformation.getValidityIntervall();
            }

            @Override
            public String getAuthor() {
                return policyInformation.getAuthor();
            }

            @Override
            public List<? extends InternationalizedString> getName() {
                return policyInformation.getName();
            }

            @Override
            public List<? extends InternationalizedString> getDescription() {
                return policyInformation.getDescription();
            }

            @Override
            public String getVersion() {
                return policyInformation.getVersion();
            }

            @Override
            public String getPolicyName(String language) {
                return policyInformation.getPolicyName(language);
            }

            @Override
            void setValidityIntervall(ValidityIntervall validityIntervall) {
                this.fail();
            }

            @Override
            void setAuthor(String author) {
                this.fail();
            }

            @Override
            void setName(List<? extends InternationalizedString> names) {
                this.fail();
            }

            @Override
            void setDescription(List<? extends InternationalizedString> descriptions) {
                this.fail();
            }

            @Override
            void setVersion(String version) {
                this.fail();
            }

            private void fail() {
                throw new UnsupportedOperationException("modification not supported");
            }
        };
    }
}

