/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.impl.FileReferenceResolver;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class MappingFileReferenceResolver
extends FileReferenceResolver
implements ReferenceResolver {
    private final Map<String, String> fileMap;

    public Map<String, String> getFileMap() {
        return this.fileMap;
    }

    public MappingFileReferenceResolver(File baseFolder, Map<String, String> fileMap) {
        super(baseFolder);
        this.fileMap = fileMap;
    }

    @Override
    public InputStream getReference(String uri) {
        String tmp;
        boolean canResolve = super.canResolve(uri);
        String mappedName = uri;
        if (!canResolve && (tmp = this.fileMap.get(uri)) != null) {
            mappedName = tmp;
        }
        return super.getReference(mappedName);
    }

    @Override
    public boolean canResolve(String uri) {
        boolean canResolve = super.canResolve(uri);
        if (!canResolve) {
            canResolve = super.canResolve(this.fileMap.get(uri));
        }
        return canResolve;
    }
}

