/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.ReferenceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReferenceResolver
implements ReferenceResolver {
    protected File baseFolder;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReferenceResolver.class);

    public FileReferenceResolver(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    @Override
    public InputStream getReference(String uri) {
        File f = this.getFile(uri);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not get reference.", (Throwable)e);
        }
        return fis;
    }

    public File getFile(String uri) {
        File f = new File(uri);
        if (!f.isAbsolute()) {
            f = new File(this.baseFolder, uri);
        }
        return f;
    }

    @Override
    public boolean canResolve(String uri) {
        if (uri == null) {
            return false;
        }
        File f = this.getFile(uri);
        return f.exists() && f.isFile();
    }
}

