/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;

public class DocumentImpl
implements Document {
    private final String id;
    private final String name;
    private final DataHandler dataHandler;
    private final String contentType;
    private final ReferenceResolver referenceResolver;

    public DocumentImpl(String id, String name, DataHandler dataHandler, String contentType) {
        this(id, name, dataHandler, contentType, null);
    }

    public DocumentImpl(String id, String name, DataHandler dataHandler, String contentType, ReferenceResolver referenceResolver) {
        this(id, name, dataHandler, contentType, referenceResolver, true);
    }

    public DocumentImpl(String id, String name, DataHandler dataHandler, String contentType, ReferenceResolver referenceResolver, boolean checkStringValues) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("DataHandler can not be null");
        }
        if (checkStringValues) {
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("id can not be null or empty");
            }
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("name can not be null or empty");
            }
            if (contentType == null || contentType.isEmpty()) {
                throw new IllegalArgumentException("format can not be null or empty");
            }
        }
        this.name = name;
        this.id = id;
        this.dataHandler = dataHandler;
        this.contentType = contentType;
        this.referenceResolver = referenceResolver;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ReferenceResolver referenceResolver = this.getReferenceResolver();
        if (referenceResolver != null && referenceResolver.canResolve(this.name)) {
            return referenceResolver.getReference(this.name);
        }
        return this.dataHandler.getInputStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }
}

