/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

public enum Cardinality {
    NONE(0, 0),
    ONE(1, 1),
    ONE_OR_MORE(1, Integer.MAX_VALUE),
    ZERO_OR_ONE(0, 1),
    ZERO_OR_MORE(0, Integer.MAX_VALUE);

    private final int min;
    private final int max;

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private Cardinality(int min, int max) {
        if (max < 0 || min < 0) {
            throw new IllegalArgumentException("minimum and maximum of cardinality must be greater equals than zero");
        }
        if (min > max) {
            throw new IllegalArgumentException("minimum can no be greater than maximum");
        }
        this.min = min;
        this.max = max;
    }

    public boolean check(int number) {
        return this.min <= number && number <= this.max;
    }
}

