/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.ProcessorType;
import de.governikus.csl.uom.RequestProcessor;
import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;

public abstract class AbstractRequestProcessor
implements RequestProcessor {
    public AbstractRequestProcessor() throws IllegalArgumentException {
        Class<?> o1 = this.getClass();
        if (!o1.isAnnotationPresent(ProcessorType.class)) {
            throw new IllegalArgumentException("missing @" + ProcessorType.class.getName() + " annotation to detect type");
        }
    }

    public String getID() {
        ProcessorType pt = this.getClass().getAnnotation(ProcessorType.class);
        return pt.id().getID();
    }

    public Class<? extends RequestProcessor> getProcessorType() {
        ProcessorType pt = this.getClass().getAnnotation(ProcessorType.class);
        return pt.type();
    }

    public static Annotation createProcessorQualifier(RequestProcessor.ProcessorID id, Class<? extends RequestProcessor> type) {
        if (type.isAnnotationPresent(ProcessorType.class)) {
            ProcessorType pt = type.getAnnotation(ProcessorType.class);
            return new ProcessorQualifier(pt.type(), pt.id());
        }
        return new ProcessorQualifier(type, id);
    }

    private static class ProcessorQualifier
    extends AnnotationLiteral<ProcessorType>
    implements ProcessorType {
        private static final long serialVersionUID = -5396641530837425975L;
        private RequestProcessor.ProcessorID id;
        private Class<? extends RequestProcessor> type;

        public ProcessorQualifier(Class<? extends RequestProcessor> type, RequestProcessor.ProcessorID id) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Class<? extends RequestProcessor> type() {
            return this.type;
        }

        @Override
        public RequestProcessor.ProcessorID id() {
            return this.id;
        }
    }
}

