/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginCategoryType;
import de.governikus.csl.uom.PluginType;
import javax.enterprise.util.AnnotationLiteral;

public abstract class AbstractPlugin
implements Plugin {
    public AbstractPlugin() throws IllegalArgumentException {
        Class<?> o1 = this.getClass();
        if (!o1.isAnnotationPresent(PluginType.class)) {
            throw new IllegalArgumentException("missing @" + PluginType.class.getName() + " annotation to detect ID");
        }
    }

    public String getID() {
        PluginType pt = this.getClass().getAnnotation(PluginType.class);
        return pt.id().getID();
    }

    public Class<? extends Plugin> getPluginType() {
        PluginType pt = this.getClass().getAnnotation(PluginType.class);
        return pt.type();
    }

    public static PluginQualifier createPluginQualifier(Plugin.PluginID id, Class<? extends Plugin> type) {
        if (type.isAnnotationPresent(PluginType.class)) {
            PluginType pluginType = type.getAnnotation(PluginType.class);
            return new PluginQualifier(pluginType.id(), pluginType.type());
        }
        return new PluginQualifier(id, type);
    }

    public static PluginCategoryQualifier createPluginCategoryQualifier(Plugin.PluginCategoryID id, Class<? extends Plugin> type) {
        if (type.isAnnotationPresent(PluginCategoryType.class)) {
            PluginCategoryType pluginCategoryType = type.getAnnotation(PluginCategoryType.class);
            return new PluginCategoryQualifier(pluginCategoryType.id(), pluginCategoryType.type());
        }
        return new PluginCategoryQualifier(id, type);
    }

    public static class PluginCategoryQualifier
    extends AnnotationLiteral<PluginCategoryType>
    implements PluginCategoryType {
        private static final long serialVersionUID = -4396641530837425975L;
        private Plugin.PluginCategoryID id;
        private Class<? extends Plugin> type;

        public PluginCategoryQualifier(Plugin.PluginCategoryID id, Class<? extends Plugin> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Class<? extends Plugin> type() {
            return this.type;
        }

        @Override
        public Plugin.PluginCategoryID id() {
            return this.id;
        }
    }

    public static class PluginQualifier
    extends AnnotationLiteral<PluginType>
    implements PluginType {
        private static final long serialVersionUID = -4396641530837425975L;
        private Plugin.PluginID id;
        private Class<? extends Plugin> type;

        public PluginQualifier(Plugin.PluginID id, Class<? extends Plugin> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Class<? extends Plugin> type() {
            return this.type;
        }

        @Override
        public Plugin.PluginID id() {
            return this.id;
        }
    }
}

