/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.i18n;

import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFormatUtils.class);
    public static final String KEY_DATE_FORMAT_LONG = "datetime.format.long";

    private MessageFormatUtils() {
    }

    public static String format(ResourceBundle rb, String templateKey, boolean replaceFormats, Object ... args) {
        try {
            return MessageFormatUtils.formatTemplate(rb, rb.getString(templateKey), replaceFormats, args);
        }
        catch (MissingResourceException mrEx) {
            LOGGER.error("Failed retrieving message template for key '{}' using resource bundle '{}_{}'!", new Object[]{templateKey, rb.getBaseBundleName(), rb.getLocale()});
            return templateKey;
        }
    }

    public static String formatTemplate(ResourceBundle rb, String template, boolean replaceFormats, Object ... args) {
        if (args == null || args.length == 0 || template.indexOf("{") < 0) {
            return template;
        }
        SimpleDateFormat sdf = null;
        String dateFormat = MessageFormatUtils.getDateFormat(rb);
        if (dateFormat != null) {
            sdf = new SimpleDateFormat(dateFormat, rb.getLocale());
        }
        MessageFormat msgFormat = new MessageFormat(template, rb.getLocale());
        boolean formatChanged = false;
        Format[] formats = msgFormat.getFormatsByArgumentIndex();
        if (replaceFormats) {
            for (int cnt = 0; cnt < formats.length; ++cnt) {
                if (formats[cnt] == null || !(formats[cnt] instanceof SimpleDateFormat) || sdf == null) continue;
                formatChanged = true;
                formats[cnt] = sdf;
            }
            if (formatChanged) {
                msgFormat.setFormatsByArgumentIndex(formats);
            }
        }
        Object[] argsConverted = MessageFormatUtils.convertArguments(args);
        for (int cnt = 0; cnt < Math.min(formats.length, argsConverted.length); ++cnt) {
            if (!(argsConverted[cnt] instanceof Date) || formats[cnt] != null || sdf == null) continue;
            argsConverted[cnt] = sdf.format(argsConverted[cnt]);
        }
        try {
            return msgFormat.format(argsConverted);
        }
        catch (IllegalArgumentException iaEx) {
            LOGGER.error("Failed formatting template message with parameters: '{}' for template '{}' - returning plain template!", (Object)iaEx.getLocalizedMessage(), (Object)template);
            return template;
        }
    }

    private static String getDateFormat(ResourceBundle rb) {
        try {
            return rb.getString(KEY_DATE_FORMAT_LONG);
        }
        catch (MissingResourceException mrEx) {
            return null;
        }
    }

    private static Object[] convertArguments(Object[] args) {
        int cnt = 0;
        Object[] convArgs = new Object[args.length];
        for (Object obj : args) {
            convArgs[cnt++] = MessageFormatUtils.convertDatatype(obj);
        }
        return convArgs;
    }

    private static Object convertDatatype(Object obj) {
        if (obj instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)obj).toGregorianCalendar().getTime();
        }
        return obj;
    }
}

