/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.i18n;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ChainingResourceBundle
extends ResourceBundle {
    private static final String LOCALE_ERR = "Chaining resource bundle and overlay resource bundle use different locales: %s <-> %s(%s)";
    private ResourceBundle head;

    public ChainingResourceBundle(String baseName, Locale locale) {
        this(ResourceBundle.getBundle(baseName, locale));
    }

    public ChainingResourceBundle(ResourceBundle bundle) {
        this.head = bundle;
    }

    public void addOverlay(String baseName) {
        ChainingResourceBundle crb = new ChainingResourceBundle(baseName, this.getLocale());
        crb.setParent(this.head);
        this.head = crb;
    }

    public void addOverlay(ResourceBundle bundle) {
        Locale otherLocale;
        Locale thisLocale = this.getLocale();
        if (!thisLocale.equals(otherLocale = bundle.getLocale())) {
            throw new IllegalArgumentException(String.format(LOCALE_ERR, thisLocale, bundle.getBaseBundleName(), otherLocale));
        }
        ChainingResourceBundle crb = new ChainingResourceBundle(bundle);
        crb.setParent(this.head);
        this.head = crb;
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            return this.head.getObject(key);
        }
        catch (MissingResourceException mr_ex) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.head.keySet());
        return Collections.enumeration(keys);
    }

    @Override
    public Locale getLocale() {
        Locale locale = this.head.getLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }
}

