/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.encrypt;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PWEnc {
    private static final Logger LOG = LoggerFactory.getLogger((String)PWEnc.class.getName());
    private static String salt;
    private static int iterations;
    private static int keySize;
    private static byte[] ivBytes;
    private static SecretKey secretKey;

    public static void main(String[] args) throws Exception {
        salt = PWEnc.getSalt();
        char[] message = "PasswordToEncrypt".toCharArray();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message: {}", (Object)String.valueOf(message));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted: {}", (Object)PWEnc.encrypt(message));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decrypted: {}", (Object)PWEnc.decrypt(PWEnc.encrypt(message).toCharArray()));
        }
    }

    public static String encrypt(char[] plaintext) throws Exception {
        byte[] saltBytes = salt.getBytes();
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(plaintext, saltBytes, iterations, keySize);
        secretKey = skf.generateSecret(spec);
        SecretKeySpec secretSpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, secretSpec);
        AlgorithmParameters params = cipher.getParameters();
        ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
        byte[] encryptedTextBytes = cipher.doFinal(String.valueOf(plaintext).getBytes("UTF-8"));
        return DatatypeConverter.printBase64Binary((byte[])encryptedTextBytes);
    }

    public static String decrypt(char[] encryptedText) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)encryptedText);
        }
        byte[] encryptedTextBytes = DatatypeConverter.parseBase64Binary((String)new String(encryptedText));
        SecretKeySpec secretSpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretSpec, new IvParameterSpec(ivBytes));
        byte[] decryptedTextBytes = null;
        try {
            decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return new String(decryptedTextBytes);
    }

    public static String getSalt() throws Exception {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[20];
        sr.nextBytes(salt);
        return new String(salt);
    }

    static {
        iterations = 65536;
        keySize = 256;
    }
}

