/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.docs;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.docs.StreamProviderDocument;
import de.governikus.csl.uom.util.SwapFileDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class DelegatingStreamDocument
implements Document {
    private static final int DEFAULT_THRESHOLD = 0xA00000;
    private Document document;

    public DelegatingStreamDocument(String id, String name, InputStream stream, String contentType, File tempFile, int threshold) throws IOException {
        this.document = new SwapFileDocument(name, id, tempFile, threshold);
        ((SwapFileDocument)this.document).consume(stream);
        this.setContentType(contentType);
        ((SwapFileDocument)this.document).close();
    }

    public DelegatingStreamDocument(String name, InputStream stream, String contentType, File tempFile, int threshold) throws IOException {
        this(name, name, stream, contentType, tempFile, threshold);
    }

    public DelegatingStreamDocument(String name, InputStream stream, File tempFile, int threshold) throws IOException {
        this(name, name, stream, null, tempFile, threshold);
    }

    public DelegatingStreamDocument(String id, String name, InputStream stream, String contentType) throws IOException {
        this(id, name, stream, contentType, Files.createTempFile("swappedStreamDocument", null, new FileAttribute[0]).toFile(), 0xA00000);
    }

    public DelegatingStreamDocument(String name, InputStream stream, String contentType) throws IOException {
        this.document = new ByteArrayDocument(stream != null ? IOUtils.toByteArray((InputStream)stream) : new byte[]{}, name);
        this.setContentType(contentType);
    }

    public DelegatingStreamDocument(String name, InputStream stream) throws IOException {
        this(name, stream, null);
    }

    public DelegatingStreamDocument(String id, String name, StreamProvider streamProvider, String contentType) throws IOException {
        this.document = new StreamProviderDocument(streamProvider, name, id);
        this.setContentType(contentType);
    }

    public DelegatingStreamDocument(String name, StreamProvider streamProvider, String contentType) throws IOException {
        this(name, name, streamProvider, contentType);
    }

    public DelegatingStreamDocument(String name, StreamProvider streamProvider) throws IOException {
        this(name, name, streamProvider, null);
    }

    @Override
    public String getId() {
        return this.document.getId();
    }

    @Override
    public String getName() {
        return this.document.getName();
    }

    @Override
    public String getContentType() {
        return this.document.getContentType();
    }

    public void setContentType(String contentType) {
        if (this.document instanceof SwapFileDocument) {
            ((SwapFileDocument)this.document).setContentType(contentType);
        } else if (this.document instanceof StreamProviderDocument) {
            ((StreamProviderDocument)this.document).setContentType(contentType);
        } else if (this.document instanceof ByteArrayDocument) {
            ((ByteArrayDocument)this.document).setContentType(contentType);
        }
    }

    @Override
    public ReferenceResolver getReferenceResolver() {
        return this.document.getReferenceResolver();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (this.document instanceof SwapFileDocument) {
            ((SwapFileDocument)this.document).setReferenceResolver(referenceResolver);
        } else if (this.document instanceof StreamProviderDocument) {
            ((StreamProviderDocument)this.document).setReferenceResolver(referenceResolver);
        } else if (this.document instanceof ByteArrayDocument) {
            ((ByteArrayDocument)this.document).setReferenceResolver(referenceResolver);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.document.getInputStream();
    }
}

