/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.docs;

import de.governikus.csl.uom.DetachedContentCallback;
import de.governikus.csl.uom.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasenameMappingDetachedContentCallback
implements DetachedContentCallback {
    private List<String> sigFileExtensionAllowed = new ArrayList<String>(Arrays.asList("p7s", "pkcs7", "signature"));

    @Override
    public List<Document> retrieveDetachedContent(Document signatureDoc, List<Document> contentDocs) {
        return this.mapContentsToDetachedSignatureByName(signatureDoc, contentDocs);
    }

    private List<Document> mapContentsToDetachedSignatureByName(Document sig, List<Document> documents) {
        ArrayList<Document> result = new ArrayList<Document>();
        if (documents == null || documents.isEmpty()) {
            return result;
        }
        documents.stream().filter(d -> !this.hasSignatureFileExtension((Document)d)).filter(x -> this.hasSameBaseName((Document)x, sig)).forEach(result::add);
        return result;
    }

    private boolean hasSameBaseName(Document content, Document sig) {
        if (sig == null) {
            return false;
        }
        int lastIndexOf = sig.getName().lastIndexOf(".");
        return content != null && lastIndexOf > 0 && content.getName().equalsIgnoreCase(sig.getName().substring(0, lastIndexOf));
    }

    private boolean hasSignatureFileExtension(Document document) {
        int extPos = document.getName().lastIndexOf(".");
        return extPos > 0 && this.sigFileExtensionAllowed != null && this.sigFileExtensionAllowed.contains(document.getName().substring(extPos + 1).toLowerCase());
    }

    public List<String> getSignatureFileExtensionsAllowed() {
        return this.sigFileExtensionAllowed;
    }
}

