/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.decrypt.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.decrypt.DecryptOptions;
import de.governikus.csl.uom.decrypt.DecryptPolicy;
import de.governikus.csl.uom.decrypt.RecipientInfo;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DecryptOptionsImpl
implements DecryptOptions {
    protected DecryptPolicy policy;
    protected Set<Class<? extends Document>> documentFormatClasses;
    protected String pluginId;
    protected Set<RecipientInfo> recipientInfos;
    protected String encryptionAlgorithmURI;

    public void setEncryptionAlgorithmURI(String encryptionAlgorithmURI) {
        this.encryptionAlgorithmURI = encryptionAlgorithmURI;
    }

    public DecryptOptionsImpl() throws IllegalArgumentException {
        this((Set<Class<? extends Document>>)null);
    }

    public DecryptOptionsImpl(DecryptOptions decryptOptions) throws IllegalArgumentException {
        if (decryptOptions == null) {
            throw new IllegalArgumentException("Copy-Constructor only usable for existing DecryptOptions");
        }
        this.policy = (DecryptPolicy)decryptOptions.getPolicy();
        this.pluginId = decryptOptions.getPluginID();
        this.encryptionAlgorithmURI = decryptOptions.getEncryptionAlgorithmURI();
        this.documentFormatClasses = DecryptOptionsImpl.checkSetNotNullOrEmptyOrContainsOnlyNull(decryptOptions.getInputDocumentFormatClasses(), "Document class");
        this.recipientInfos = DecryptOptionsImpl.checkSetNotNullOrEmptyOrContainsOnlyNull(decryptOptions.getRecipientInfos(), "RecipientInfo");
    }

    public static <E> Set<E> checkSetNotNullOrEmptyOrContainsOnlyNull(Set<E> uncheckedSet, String msg) throws IllegalArgumentException {
        if (uncheckedSet == null || uncheckedSet.isEmpty()) {
            throw new IllegalArgumentException("at least one " + msg + " must exist");
        }
        LinkedHashSet<E> checkedSet = new LinkedHashSet<E>(uncheckedSet);
        checkedSet.remove(null);
        if (checkedSet.isEmpty()) {
            throw new IllegalArgumentException("at least one " + msg + " must exist, that is not null");
        }
        return checkedSet;
    }

    public DecryptOptionsImpl(String encryptionAlgorithmURI) {
        this(null, null, encryptionAlgorithmURI, null);
    }

    public DecryptOptionsImpl(Plugin.PluginID pluginId, String encryptionAlgorithmURI, Set<Class<? extends Document>> documentFormatClasses) {
        this(pluginId, null, encryptionAlgorithmURI, documentFormatClasses);
    }

    public DecryptOptionsImpl(Plugin.PluginID pluginId, DecryptPolicy decryptPolicy, String encryptionAlgorithmURI, Set<Class<? extends Document>> documentFormatClasses) {
        this.policy = decryptPolicy;
        this.documentFormatClasses = documentFormatClasses;
        this.pluginId = pluginId == null ? null : pluginId.getID();
        this.recipientInfos = new LinkedHashSet<RecipientInfo>();
    }

    public DecryptOptionsImpl(Set<Class<? extends Document>> documentFormatClasses) {
        this(null, null, documentFormatClasses);
    }

    @Override
    public DecryptPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public Set<Class<? extends Document>> getInputDocumentFormatClasses() {
        return this.documentFormatClasses;
    }

    @Override
    public String getPluginID() {
        return this.pluginId;
    }

    void setPluginID(String id) {
        this.pluginId = id;
    }

    void setInputdocumentFormatClasses(Set<Class<? extends Document>> inputDocumentClasses) {
        this.documentFormatClasses = Collections.unmodifiableSet(DecryptOptionsImpl.checkSetNotNullOrEmptyOrContainsOnlyNull(inputDocumentClasses, "Document format class"));
    }

    void setPolicy(DecryptPolicy policy) {
        this.policy = policy;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public String getOutputStreamMetaInf() {
        return null;
    }

    void setRecipientInfos(Set<RecipientInfo> recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    void addRecipientInfo(RecipientInfo RecipientInfo2) {
        if (RecipientInfo2 == null) {
            return;
        }
        this.recipientInfos.add(RecipientInfo2);
    }

    void removeRecipientInfo(RecipientInfo RecipientInfo2) {
        this.recipientInfos.remove(RecipientInfo2);
    }

    @Override
    public String getEncryptionAlgorithmURI() {
        return this.encryptionAlgorithmURI;
    }

    @Override
    public Set<RecipientInfo> getRecipientInfos() {
        return this.recipientInfos;
    }
}

