/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.decrypt.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.decrypt.DecryptOptions;
import de.governikus.csl.uom.decrypt.DecryptPolicy;
import de.governikus.csl.uom.decrypt.RecipientInfo;
import de.governikus.csl.uom.decrypt.impl.DecryptOptionsImpl;
import java.util.Set;

public class DecryptOptionsBuilder {
    private DecryptOptionsImpl decryptOptions;

    public DecryptOptionsBuilder() {
        this.decryptOptions = new DecryptOptionsImpl();
    }

    public DecryptOptionsBuilder(DecryptOptions decryptOptions) {
        if (!(decryptOptions instanceof DecryptOptionsImpl)) {
            throw new IllegalArgumentException("only SignOptionsImpl currently supported");
        }
        this.decryptOptions = (DecryptOptionsImpl)decryptOptions;
    }

    public DecryptOptionsBuilder addRecipientInfo(RecipientInfo recipientInfo) {
        this.decryptOptions.addRecipientInfo(recipientInfo);
        return this;
    }

    public DecryptOptions build() {
        if (this.decryptOptions.getRecipientInfos().isEmpty()) {
            throw new IllegalArgumentException("recipient infos can not be empty");
        }
        if (this.decryptOptions.getInputDocumentFormatClasses() == null || this.decryptOptions.getInputDocumentFormatClasses().isEmpty()) {
            throw new IllegalArgumentException("input document classes can not be null or empty");
        }
        if (this.decryptOptions.getPluginID() == null) {
            throw new IllegalArgumentException("plugin type can not be null or empty");
        }
        if (this.decryptOptions.getPolicy() == null) {
            throw new IllegalArgumentException("policy required");
        }
        return this.decryptOptions;
    }

    public String getEncryptionAlgorithmURI() {
        return this.decryptOptions.getEncryptionAlgorithmURI();
    }

    public DecryptOptionsBuilder setEncryptionAlgorithmURI(String encryptionAlgorithmURI) {
        this.decryptOptions.setEncryptionAlgorithmURI(encryptionAlgorithmURI);
        return this;
    }

    public Set<Class<? extends Document>> getInputDocumentFormatClasses() {
        return this.decryptOptions.getInputDocumentFormatClasses();
    }

    public String getPluginID() {
        return this.decryptOptions.getPluginID();
    }

    public DecryptPolicy getPolicy() {
        return this.decryptOptions.getPolicy();
    }

    public Set<RecipientInfo> getRecipientInfos() {
        return this.decryptOptions.getRecipientInfos();
    }

    public DecryptOptionsBuilder removeRecipientInfo(RecipientInfo recipientInfo) {
        this.decryptOptions.removeRecipientInfo(recipientInfo);
        return this;
    }

    public DecryptOptionsBuilder setInputDocumentFormatClasses(Set<Class<? extends Document>> inputDocumentClasses) {
        this.decryptOptions.setInputdocumentFormatClasses(inputDocumentClasses);
        return this;
    }

    public DecryptOptionsBuilder setPluginID(String id) {
        this.decryptOptions.setPluginID(id);
        return this;
    }

    public DecryptOptionsBuilder setPolicy(DecryptPolicy policy) {
        this.decryptOptions.setPolicy(policy);
        return this;
    }

    public DecryptOptionsBuilder setRecipientInfos(Set<RecipientInfo> recipientInfos) {
        this.decryptOptions.setRecipientInfos(recipientInfos);
        return this;
    }
}

