/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.core.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ResourceUtil;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.impl.FileDocumentAltNameImpl;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SignedFileAccessor
implements SignedData {
    private FileDocumentImpl signature;
    private List<FileDocumentImpl> contents;

    public SignedFileAccessor(String signatureFile, String contentFile) {
        File signature = this.getFile(signatureFile);
        File content = null;
        if (contentFile != null) {
            content = this.getFile(contentFile);
        }
        this.init(signature, null, content, null);
    }

    private File getFile(String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            URL url = ResourceUtil.getResource(SignedFileAccessor.class, fileName);
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                file = new File(url.getFile());
            }
        }
        return file;
    }

    public SignedFileAccessor(File signatureFile, File contentFile) {
        this.init(signatureFile, null, contentFile, null);
    }

    public SignedFileAccessor(File signatureFile, String altSignatureName, File contentFile, String altContentName) {
        this.init(signatureFile, altSignatureName, contentFile, altContentName);
    }

    private void init(File signatureFile, String signatureName, File contentFile, String contentName) {
        this.signature = new FileDocumentAltNameImpl(signatureFile, signatureFile.getName(), signatureName);
        if (contentFile != null) {
            this.contents = new ArrayList<FileDocumentImpl>();
            this.contents.add(new FileDocumentAltNameImpl(contentFile, contentFile.getName(), contentName));
        }
    }

    @Override
    public Document getSignature() {
        return this.signature;
    }

    @Override
    public List<? extends Document> getContents() {
        return this.contents;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.signature != null) {
            sb.append("Signature: ");
            sb.append(this.signature.getName());
        }
        return sb.toString();
    }

    @Override
    public List<byte[]> getHashValues() {
        return null;
    }
}

