/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.configuration;

import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProxyConfigurationImpl
implements ProxyConfiguration {
    private final List<String> proxyExceptions;
    private String proxyHost;
    private int proxyPort;
    private String username;
    private String password;
    private boolean LDAPProxy;
    private boolean NoCacheHeader;

    public ProxyConfigurationImpl(String proxyHost, int port) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.proxyExceptions = new ArrayList<String>();
    }

    public ProxyConfigurationImpl(String proxyHost, int port, String ... bypassedHosts) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.proxyExceptions = bypassedHosts != null && bypassedHosts.length > 0 ? Arrays.asList(bypassedHosts) : new ArrayList<String>();
    }

    public ProxyConfigurationImpl(String proxyHost, int port, List<String> bypassedHostCol) {
        this.proxyHost = proxyHost;
        this.proxyPort = port;
        this.proxyExceptions = bypassedHostCol != null && bypassedHostCol.size() > 0 ? bypassedHostCol : new ArrayList<String>();
    }

    public ProxyConfigurationImpl() {
        this.proxyExceptions = new ArrayList<String>();
    }

    public ProxyConfigurationImpl(String proxyHost, int proxyPort, String proxyUser, String proxyPass, List<String> bypassedHostCol) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = proxyUser;
        this.password = proxyPass;
        this.proxyExceptions = bypassedHostCol != null && bypassedHostCol.size() > 0 ? bypassedHostCol : new ArrayList<String>();
    }

    @Override
    public List<String> getProxyExceptions() {
        return this.proxyExceptions;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isLDAPProxy() {
        return this.LDAPProxy;
    }

    public void setLDAPProxy(boolean lDAPProxy) {
        this.LDAPProxy = lDAPProxy;
    }

    @Override
    public boolean isNoCacheHeader() {
        return this.NoCacheHeader;
    }

    public void setNoCacheHeader(boolean noCacheHeader) {
        this.NoCacheHeader = noCacheHeader;
    }
}

