/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.client;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.InstanceProviderManaged;
import de.governikus.csl.uom.RequestProcessor;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.augment.AugmentProcessor;
import de.governikus.csl.uom.augment.AugmentRequest;
import de.governikus.csl.uom.client.CSLClientApi;
import de.governikus.csl.uom.client.CSLClientApiException;
import de.governikus.csl.uom.decrypt.DecryptProcessor;
import de.governikus.csl.uom.decrypt.DecryptRequest;
import de.governikus.csl.uom.decrypt.DecryptedDataResponse;
import de.governikus.csl.uom.hash.HashProcessor;
import de.governikus.csl.uom.hash.HashRequest;
import de.governikus.csl.uom.hash.HashResponse;
import de.governikus.csl.uom.sign.SignProcessor;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.tsp.TimestampProcessor;
import de.governikus.csl.uom.tsp.TimestampRequest;
import de.governikus.csl.uom.tsp.TimestampResponse;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ValidateOptions;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.Closeable;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSLClientApiImpl
implements CSLClientApi,
InstanceProviderManaged {
    private static final Logger LOG = LoggerFactory.getLogger(CSLClientApiImpl.class);
    private static CSLClientApiImpl instance = null;
    private final InstanceProvider manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized CSLClientApiImpl getInstance(InstanceProvider manager) throws CSLClientApiException {
        LOG.debug("getting CSLClientApiImpl singleton instance");
        if (Security.getProvider("BC") == null) {
            Class<CSLClientApiImpl> clazz = CSLClientApiImpl.class;
            // MONITORENTER : de.governikus.csl.uom.client.CSLClientApiImpl.class
            CryptoProviderUtil.registerBouncyCastleIfNotAvailable();
            // MONITOREXIT : clazz
        }
        if (instance != null) return instance;
        LOG.debug("creating CSLClientApiImpl singleton instance");
        instance = new CSLClientApiImpl(manager);
        return instance;
    }

    private CSLClientApiImpl(InstanceProvider manager) throws CSLClientApiException {
        if (manager == null) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PREPARE, "manager instance can not be null");
        }
        this.manager = manager;
    }

    @Override
    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        try {
            LOG.debug("calling SignProcessor");
            SignProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.SIGN, SignProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.SIGN, processor);
            SignedDataResponse signedDataResponse = processor.sign(signRequest, env);
            return signedDataResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at signing with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("SignProcessor finished");
        }
    }

    private static <R extends RequestProcessor> R checkRequestProcessor(RequestProcessor.ProcessorID processorID, R requestProcessor) throws CSLClientApiException {
        if (requestProcessor == null) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PREPARE, "request processor not found by processor ID: " + (Object)((Object)processorID));
        }
        return requestProcessor;
    }

    @Override
    public HashResponse hash(HashRequest hashRequest, Environment env) throws CoreException {
        try {
            LOG.debug("calling HashProcessor");
            HashProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.HASH, HashProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.HASH, processor);
            HashResponse hashResponse = processor.hash(hashRequest, env);
            return hashResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at hashing with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("HashProcessor finished");
        }
    }

    @Override
    public ValidateResponse validate(ValidateRequest validateRequest) throws CoreException {
        try {
            LOG.debug("calling ValidateProcessor");
            ValidateProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.VALIDATE, ValidateProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.VALIDATE, processor);
            ValidateResponse validateResponse = processor.validate(validateRequest);
            return validateResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at validating with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("ValdidateProcessor finished");
        }
    }

    @Override
    public ObjectValidationResult validate(SignedData signedData, ValidateOptions options) throws CoreException {
        try {
            LOG.debug("calling ValidateProcessor");
            ValidateProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.VALIDATE, ValidateProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.VALIDATE, processor);
            ObjectValidationResult objectValidationResult = processor.validate(signedData, options);
            return objectValidationResult;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at validating with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("ValidateProcessor finished");
        }
    }

    @Override
    public TimestampResponse timestamp(TimestampRequest timestampRequest, Closeable transportClient, Environment env) throws CoreException {
        try {
            LOG.debug("calling TimestampProcessor");
            TimestampProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.TIMESTAMP, TimestampProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.TIMESTAMP, processor);
            TimestampResponse timestampResponse = processor.timestamp(timestampRequest, transportClient, env);
            return timestampResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at timestamping with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("TimestampProcessor finished");
        }
    }

    @Override
    public SignedDataResponse augment(AugmentRequest augmentRequest) throws CoreException {
        try {
            LOG.debug("calling AugmentProcessor");
            AugmentProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.AUGMENT, AugmentProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.AUGMENT, processor);
            SignedDataResponse signedDataResponse = processor.augment(augmentRequest);
            return signedDataResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at augmenting with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("AugmentProcessor finished");
        }
    }

    @Override
    public DecryptedDataResponse decrypt(DecryptRequest decryptRequest, Environment env) throws CoreException {
        try {
            LOG.debug("calling DecryptProcessor");
            DecryptProcessor processor = this.manager.getRequestProcessor(RequestProcessor.ProcessorID.DECRYPT, DecryptProcessor.class, null);
            CSLClientApiImpl.checkRequestProcessor(RequestProcessor.ProcessorID.DECRYPT, processor);
            DecryptedDataResponse decryptedDataResponse = processor.decrypt(decryptRequest, env);
            return decryptedDataResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLClientApiException(CSLClientApiException.Failure.PROCESSING_FAILED, "CSLClientApi failed at decrypting with not expected exception: " + e.getMessage(), e);
        }
        finally {
            LOG.debug("DecryptProcessor finished");
        }
    }

    @Override
    public InstanceProvider getInstanceProvider() {
        return this.manager;
    }
}

