/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.cdi;

import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.ProcessorParameters;
import de.governikus.csl.uom.RequestProcessor;
import de.governikus.csl.uom.cdi.CSLBean;
import de.governikus.csl.uom.cdi.EnhancedInstance;
import de.governikus.csl.uom.cdi.SimpleBeanImpl;
import de.governikus.csl.uom.service.Service;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Singleton;

public class SimpleEnhancedInstanceImpl<T>
implements EnhancedInstance<T> {
    private static Map<Class<?>, Object> singletonCache = new LinkedHashMap();
    private Set<CSLBean<T>> beans;
    private final InstanceProvider instanceProvider;
    private final Object params;

    public SimpleEnhancedInstanceImpl(InstanceProvider instanceProvider, Set<Class<? super T>> beanClasses, Object params) throws NullPointerException {
        this.beans = this.createBeans(beanClasses);
        this.instanceProvider = Objects.requireNonNull(instanceProvider, "manager service is required");
        this.params = params;
    }

    private boolean accept(CSLBean<T> bean, Annotation[] qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            return true;
        }
        boolean accept = true;
        Class<?> beanClass = bean.getBeanClass();
        for (int i = 0; i < qualifiers.length; ++i) {
            accept &= beanClass.isAnnotationPresent(qualifiers[i].annotationType()) && beanClass.getAnnotation(qualifiers[i].annotationType()).equals(qualifiers[i]);
        }
        return accept;
    }

    private <U extends T> boolean accept(CSLBean<T> bean, Class<U> subtype) {
        return subtype.isAssignableFrom(bean.getBeanClass());
    }

    private <U extends T> boolean accept(CSLBean<T> bean, TypeLiteral<U> subtype) {
        return this.accept(bean, subtype.getRawType());
    }

    private Set<CSLBean<T>> createBeans(Set<Class<? super T>> beanClasses) {
        LinkedHashSet<CSLBean<T>> beans = new LinkedHashSet<CSLBean<T>>();
        if (beanClasses == null || beanClasses.isEmpty()) {
            return beans;
        }
        for (Class<T> clazz : beanClasses) {
            beans.add(new SimpleBeanImpl(clazz));
        }
        return beans;
    }

    public void destroy(T instance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        try {
            Class<?> beanClass = this.beans.iterator().next().getBeanClass();
            T newInstance = null;
            Map<Class<?>, Object> map = singletonCache;
            synchronized (map) {
                if (singletonCache.containsKey(beanClass)) {
                    return (T)singletonCache.get(beanClass);
                }
                newInstance = (T)beanClass.newInstance();
                if (newInstance instanceof Plugin) {
                    Plugin p = (Plugin)newInstance;
                    try {
                        p.initialize(this.instanceProvider);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("fail to initialize plugin: " + e.getMessage(), e);
                    }
                } else if (newInstance instanceof RequestProcessor) {
                    RequestProcessor rp = (RequestProcessor)newInstance;
                    rp.setInstanceProvider(this.instanceProvider);
                    try {
                        if (this.params instanceof ProcessorParameters) {
                            rp.setParams((ProcessorParameters)this.params);
                        }
                        rp.setParams(null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("fail to initialize processor: " + e.getMessage(), e);
                    }
                } else if (newInstance instanceof Service) {
                    Service s = (Service)newInstance;
                    s.setManagerService(this.instanceProvider);
                }
                if (beanClass.isAnnotationPresent(Singleton.class)) {
                    singletonCache.put(beanClass, newInstance);
                }
            }
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Override
    public Set<CSLBean<T>> getBeans() {
        return this.beans;
    }

    public boolean isAmbiguous() {
        return this.beans.size() > 1;
    }

    @Override
    public boolean isEmpty() {
        return this.beans.isEmpty();
    }

    public boolean isUnsatisfied() {
        return this.beans.size() == 0;
    }

    public Iterator<T> iterator() {
        return new IteratorImpl<T>(this.beans.iterator(), singletonCache);
    }

    public Instance<T> select(Annotation ... qualifiers) {
        if (this.beans.isEmpty() || qualifiers == null || qualifiers.length == 0) {
            return this;
        }
        LinkedHashSet<Class<T>> selectedClasses = new LinkedHashSet<Class<T>>();
        for (CSLBean<T> bean : this.beans) {
            if (!this.accept(bean, qualifiers)) continue;
            selectedClasses.add(bean.getBeanClass());
        }
        return new SimpleEnhancedInstanceImpl<T>(this.instanceProvider, selectedClasses, this.params);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        if (this.beans.isEmpty()) {
            return new SimpleEnhancedInstanceImpl<T>(this.instanceProvider, Collections.emptySet(), this.params);
        }
        LinkedHashSet<Class<T>> selectedClasses = new LinkedHashSet<Class<T>>();
        for (CSLBean<T> bean : this.beans) {
            if (!this.accept(bean, subtype) || !this.accept(bean, qualifiers)) continue;
            selectedClasses.add(bean.getBeanClass());
        }
        return new SimpleEnhancedInstanceImpl<T>(this.instanceProvider, selectedClasses, this.params);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        LinkedHashSet<Class<T>> selectedClasses = new LinkedHashSet<Class<T>>();
        for (CSLBean<T> bean : this.beans) {
            if (!this.accept(bean, subtype) || !this.accept(bean, qualifiers)) continue;
            selectedClasses.add(bean.getBeanClass());
        }
        return new SimpleEnhancedInstanceImpl<T>(this.instanceProvider, selectedClasses, this.params);
    }

    @Override
    public int size() {
        return this.beans.size();
    }

    private static class IteratorImpl<T>
    implements Iterator<T> {
        private final Iterator<CSLBean<T>> beanIterator;
        private final Map<Class<?>, Object> singletonCache;

        public IteratorImpl(Iterator<CSLBean<T>> beanIterator, Map<Class<?>, Object> singletonCache) {
            this.beanIterator = Objects.requireNonNull(beanIterator, "bean iterator can not be null");
            this.singletonCache = Objects.requireNonNull(singletonCache, "singleton cache can not be null");
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (action == null) {
                return;
            }
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public boolean hasNext() {
            return this.beanIterator.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            CSLBean<T> bean = this.beanIterator.next();
            Class<?> beanClass = bean.getBeanClass();
            try {
                T newInstance = null;
                Map<Class<?>, Object> map = this.singletonCache;
                synchronized (map) {
                    if (this.singletonCache.containsKey(beanClass)) {
                        return (T)this.singletonCache.get(beanClass);
                    }
                    newInstance = (T)beanClass.newInstance();
                    if (beanClass.isAnnotationPresent(Singleton.class)) {
                        this.singletonCache.put(beanClass, newInstance);
                    }
                }
                return newInstance;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("fail to initiate a bean class: " + beanClass + ", " + e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
            this.beanIterator.remove();
        }
    }
}

