/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.cdi;

import de.governikus.csl.uom.cdi.CSLBean;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Scope;

public class SimpleBeanImpl<T>
implements CSLBean<T> {
    private final Class<?> beanClass;
    private final boolean alternative;
    private final Class<? extends Annotation> scope;

    public SimpleBeanImpl(Class<?> beanClass) throws NullPointerException {
        this.beanClass = Objects.requireNonNull(beanClass, "bean class can not be null");
        this.alternative = this.beanClass.isAnnotationPresent(Alternative.class);
        this.scope = this.beanClass.isAnnotationPresent(Scope.class) ? this.beanClass.getAnnotation(Scope.class).annotationType() : Dependent.class;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public boolean isAlternative() {
        return this.alternative;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("(");
        sb.append("beanClass: " + this.beanClass);
        sb.append(", alternative: " + this.alternative);
        sb.append(", scope: " + this.scope);
        sb.append(")");
        return sb.toString();
    }
}

