/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResource(String relativeFileName) {
        URL resource = ResourceUtil.class.getResource(relativeFileName);
        if (resource == null) {
            resource = ResourceUtil.class.getClassLoader().getResource(relativeFileName);
        }
        return resource;
    }

    public static URI getResourceURI(String relativeFileName) throws URISyntaxException {
        return ResourceUtil.getResource(relativeFileName).toURI();
    }

    public static InputStream getResourceAsStream(String relativeFileName) {
        return ResourceUtil.class.getClassLoader().getResourceAsStream(relativeFileName);
    }

    public static File getResourceAsFile(String relativeFileName) {
        File f;
        URL tslFolder = ResourceUtil.getResource(relativeFileName);
        try {
            f = new File(tslFolder.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(tslFolder.getPath());
        }
        return f;
    }

    public static URL getResource(Class<?> clazz, String relativeFileName) {
        return clazz.getClassLoader().getResource(relativeFileName);
    }

    public static URI getResourceURI(Class<?> clazz, String relativeFileName) throws URISyntaxException {
        return ResourceUtil.getResource(clazz, relativeFileName).toURI();
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String relativeFileName) {
        return clazz.getClassLoader().getResourceAsStream(relativeFileName);
    }

    public static List<String> listFilesInResourceFolder(String resourceFolder) throws IOException, URISyntaxException {
        String[] files;
        URL dirURL = ResourceUtil.class.getClassLoader().getResource(resourceFolder);
        if (dirURL == null) {
            return Collections.emptyList();
        }
        if (dirURL.getProtocol().equals("file") && (files = new File(dirURL.toURI()).list()) != null) {
            return Arrays.asList(files);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                ArrayList<String> result = new ArrayList<String>();
                while (entries.hasMoreElements()) {
                    JarEntry nextElement = entries.nextElement();
                    String name = nextElement.getName();
                    if (!name.startsWith(resourceFolder) || nextElement.isDirectory()) continue;
                    result.add(name);
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }
}

