/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce.remote;

import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.jce.remote.RemoteSignaturePrivateKey;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.ResourceFailedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSignature
extends Signature {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RemoteSignature.class.getName());
    private IOException bufferWriteException;
    private Map<String, Object> keyValueParameters;
    private RemoteSignaturePrivateKey remoteSignatureKey;
    private ByteArrayOutputStream stream = null;
    private DigestOutputStream digestStream = null;
    private final String digestAlgorithmURI;
    private AlgorithmParameterSpec algorithmParameterSpec;
    private String signatureAlgorithmURI;

    public RemoteSignature(String signatureAlgorithm, String signatureAlgorithmURI, String digestAlgorithm, AlgorithmParameterSpec algorithmParameterSpec) {
        super(Objects.requireNonNull(signatureAlgorithm, "signature algorithm URI is required"));
        this.signatureAlgorithmURI = Objects.requireNonNull(signatureAlgorithmURI, "signature algorithm URI is required");
        this.digestAlgorithmURI = Objects.requireNonNull(digestAlgorithm, "digest algorithm URI is required");
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    private void checkBufferUpdatesSuccessful() throws SignatureException {
        if (this.bufferWriteException != null) {
            throw new SignatureException(this.bufferWriteException);
        }
    }

    @Override
    protected Object engineGetParameter(String param) {
        return this.keyValueParameters.get(param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        PrivateKey lPrivateKey = privateKey;
        if (PrivateKeyResource.class.isInstance(privateKey) && ((PrivateKeyResource)PrivateKeyResource.class.cast(privateKey)).isKeyAccessible()) {
            try {
                lPrivateKey = (PrivateKey)((PrivateKeyResource)PrivateKeyResource.class.cast(privateKey)).getKey();
            }
            catch (ResourceFailedException resourceFailedException) {
                // empty catch block
            }
        }
        if (lPrivateKey instanceof RemoteSignaturePrivateKey) {
            this.remoteSignatureKey = (RemoteSignaturePrivateKey)lPrivateKey;
            this.initBuffering();
            return;
        }
        throw new InvalidKeyException("not supported key - " + RemoteSignaturePrivateKey.class.getName() + " supported only");
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("verification not supported by remote signature implementation");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.algorithmParameterSpec = params;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        this.keyValueParameters.put(param, value);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] engineSign() throws SignatureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] signatureValue = this.engineSign();
        if (signatureValue.length > len) {
            throw new CSLJCERemoteSignatureException("signature value length exceeds expected maximum length");
        }
        System.arraycopy(signatureValue, 0, outbuf, offset, signatureValue.length);
        return signatureValue.length;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        try {
            this.digestStream.write(b);
        }
        catch (IOException e) {
            throw new CSLJCERemoteSignatureException("failed remote digesting bytes: " + e.getMessage(), e);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            this.digestStream.write(b, off, len);
        }
        catch (IOException e) {
            throw new CSLJCERemoteSignatureException("failed remote digesting bytes: " + e.getMessage(), e);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        try {
            this.stream.write(input.array());
        }
        catch (IOException e) {
            this.bufferWriteException = e;
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("verification not supported by remote signature implementation");
    }

    private void initBuffering() throws InvalidKeyException {
        try {
            this.stream = new ByteArrayOutputStream();
            this.digestStream = new DigestOutputStream(this.stream, MessageDigest.getInstance(this.digestAlgorithmURI, "CPP"));
            this.bufferWriteException = null;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidKeyException(e);
        }
    }
}

