/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce.remote;

import de.governikus.csl.uom.jce.remote.CSLJCERemoteCipherException;
import de.governikus.csl.uom.jce.remote.RemoteCipherKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RemoteCipher
extends Cipher {
    private static final String ERROR_MESSAGE_NOT_SUPPORTED_KEY = "not supported key - " + RemoteCipherKey.class.getName() + " supported only";
    private static final String ERROR_MESSAGE_REMOTE_STREAM_CIPHERING_NOT_SUPPORTED = "remote stream ciphering is not supported";

    private static CipherSpi create(final String algorithm) {
        return new CipherSpi(){
            private AlgorithmParameters algorithmParameters;
            private AlgorithmParameterSpec algorithmParameterSpec;
            private String mode;
            private int opmode;
            private String padding;
            private RemoteCipherKey remoteCipherKey;

            private void checkInitState() {
                if (this.remoteCipherKey == null) {
                    throw new IllegalStateException();
                }
            }

            @Override
            protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
                this.checkInitState();
                byte[] tmp = RemoteCipher.getInput(input, inputOffset, inputLen);
                return this.remoteCipherKey.doCipher(this.opmode, RemoteCipher.getAlgorithm(algorithm, this.mode, this.padding), this.algorithmParameters, this.algorithmParameterSpec, tmp);
            }

            @Override
            protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
                this.checkInitState();
                byte[] tmp = RemoteCipher.getInput(input, inputOffset, inputLen);
                try {
                    return this.remoteCipherKey.doCipher(this.opmode, RemoteCipher.getAlgorithm(algorithm, this.mode, this.padding), this.algorithmParameters, this.algorithmParameterSpec, tmp, output, outputOffset);
                }
                catch (CSLJCERemoteCipherException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CSLJCERemoteCipherException(e);
                }
            }

            @Override
            protected int engineGetBlockSize() {
                this.checkInitState();
                return this.remoteCipherKey.getBlockSize(this.opmode, this.mode, this.padding);
            }

            @Override
            protected byte[] engineGetIV() {
                this.checkInitState();
                return this.remoteCipherKey.getIV(this.opmode, this.mode, this.padding);
            }

            @Override
            protected int engineGetOutputSize(int inputLen) {
                this.checkInitState();
                return this.remoteCipherKey.getOutputSize(this.opmode, this.mode, this.padding, inputLen);
            }

            @Override
            protected AlgorithmParameters engineGetParameters() {
                return this.algorithmParameters;
            }

            @Override
            protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
                this.initCipher(opmode, key, params, null);
            }

            @Override
            protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
                this.initCipher(opmode, key, null, params);
            }

            @Override
            protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
                this.initCipher(opmode, key, null, null);
            }

            @Override
            protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
                this.mode = mode;
            }

            @Override
            protected void engineSetPadding(String padding) throws NoSuchPaddingException {
                this.padding = padding;
            }

            @Override
            protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
                throw new UnsupportedOperationException(RemoteCipher.ERROR_MESSAGE_REMOTE_STREAM_CIPHERING_NOT_SUPPORTED);
            }

            @Override
            protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
                throw new UnsupportedOperationException(RemoteCipher.ERROR_MESSAGE_REMOTE_STREAM_CIPHERING_NOT_SUPPORTED);
            }

            private void initCipher(int opmode, Key key, AlgorithmParameters algorithmParameters, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
                if (key instanceof RemoteCipherKey) {
                    this.remoteCipherKey = (RemoteCipherKey)key;
                    this.opmode = opmode;
                    this.algorithmParameters = algorithmParameters;
                    this.algorithmParameterSpec = algorithmParameterSpec;
                    return;
                }
                throw new InvalidKeyException(ERROR_MESSAGE_NOT_SUPPORTED_KEY);
            }
        };
    }

    private static String getAlgorithm(String algorithm, String mode, String padding) {
        return algorithm + "/" + mode + "/" + padding;
    }

    private static byte[] getInput(byte[] input, int inputOffset, int inputLen) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        if (input.length <= inputOffset) {
            throw new IllegalArgumentException("inputOffset cannot be greater than length of input");
        }
        if (input.length <= inputOffset + inputLen) {
            throw new IllegalArgumentException("inputOffset + inputLen cannot be greater than length of input");
        }
        byte[] tmp = new byte[inputLen];
        System.arraycopy(input, inputOffset, tmp, 0, inputLen);
        return tmp;
    }

    public RemoteCipher(String algorithm) {
        super(RemoteCipher.create(algorithm), Security.getProvider("CPP"), algorithm);
    }
}

