/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.CSLSignatureSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;

public class XMLSecSignatureAlgorithmSpi
extends SignatureAlgorithmSpi {
    private final String uri;
    private final String jceName;
    private final CSLSignatureSpi delegate;

    private XMLSecSignatureAlgorithmSpi(String uri, String jceName, Class<? extends CSLSignatureSpi> cslSignatureSpiClass) {
        this.uri = uri;
        this.jceName = jceName;
        try {
            this.delegate = cslSignatureSpiClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException();
        }
    }

    protected String engineGetURI() {
        return this.uri;
    }

    protected String engineGetJCEAlgorithmString() {
        return this.jceName;
    }

    protected String engineGetJCEProviderName() {
        return "CPP";
    }

    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this.delegate.engineUpdate(input, 0, input.length);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this.delegate.engineUpdate(input);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this.delegate.engineUpdate(buf, offset, len);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineInitSign(Key signingKey) throws XMLSignatureException {
        try {
            this.delegate.engineInitSign((PrivateKey)signingKey);
        }
        catch (InvalidKeyException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineInitSign(Key signingKey, SecureRandom secureRandom) throws XMLSignatureException {
        try {
            this.delegate.engineInitSign((PrivateKey)signingKey, secureRandom);
        }
        catch (InvalidKeyException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineInitSign(Key signingKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.delegate.engineInitSign((PrivateKey)signingKey);
            this.delegate.engineSetParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.delegate.engineSign();
        }
        catch (SignatureException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineInitVerify(Key verificationKey) throws XMLSignatureException {
        try {
            this.delegate.engineInitVerify((PublicKey)verificationKey);
        }
        catch (InvalidKeyException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            return this.delegate.engineVerify(signature);
        }
        catch (SignatureException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        try {
            this.delegate.engineSetParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XMLSignatureException((Exception)e);
        }
    }

    protected void engineSetHMACOutputLength(int HMACOutputLength) throws XMLSignatureException {
    }

    public static class XML_SHA3_512withRSAandMGF1
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_512withRSAandMGF1() {
            super("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", "SHA3-512withRSAandMGF1", CSLSignatureSpi.RsaSha3x512PssSpi.class);
        }
    }

    public static class XML_SHA3_384withRSAandMGF1
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_384withRSAandMGF1() {
            super("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", "SHA3-384withRSAandMGF1", CSLSignatureSpi.RsaSha3x512PssSpi.class);
        }
    }

    public static class XML_SHA3_256withRSAandMGF1
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_256withRSAandMGF1() {
            super("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", "SHA3-256withRSAandMGF1", CSLSignatureSpi.RsaSha3x256PssSpi.class);
        }
    }

    public static class XML_SHA3_224withRSAandMGF1
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_224withRSAandMGF1() {
            super("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", "SHA3-224withRSAandMGF1", CSLSignatureSpi.RsaSha3x256PssSpi.class);
        }
    }

    public static class XML_SHA3_512withRSA
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_512withRSA() {
            super("http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-512", "SHA3-512withRSA", CSLSignatureSpi.RsaSha3x512PssSpi.class);
        }
    }

    public static class XML_SHA3_384withRSA
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_384withRSA() {
            super("http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-384", "SHA3-384withRSA", CSLSignatureSpi.RsaSha3x512PssSpi.class);
        }
    }

    public static class XML_SHA3_256withRSA
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_256withRSA() {
            super("http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-256", "SHA3-256withRSA", CSLSignatureSpi.RsaSha3x256PssSpi.class);
        }
    }

    public static class XML_SHA3_224withRSA
    extends XMLSecSignatureAlgorithmSpi {
        public XML_SHA3_224withRSA() {
            super("http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-224", "SHA3-224withRSA", CSLSignatureSpi.RsaSha3x256PssSpi.class);
        }
    }
}

