/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PublicKeyResource;
import de.governikus.csl.uom.res.PublicKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.res.impl.PublicKeyResourceImpl;
import de.governikus.csl.uom.res.impl.PublicKeyResourceReferenceImpl;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Collections;

final class TempPrivateKeyResourceUtil {
    private TempPrivateKeyResourceUtil() {
    }

    public static PublicKeyResource createTempPublicKeyResource(PublicKey publicKey) {
        return new PublicKeyResourceImpl((PublicKeyResourceReference)new PublicKeyResourceReferenceImpl("temporary BC key", ResourceComponentType.SOFTWARE, ResourceAreaType.LOCAL, Collections.singletonList(TempPrivateKeyResourceUtil.createTempCertificate(publicKey)), null), "BC");
    }

    public static PrivateKeyResource createTempPrivateKeyResource(PrivateKey privateKey) {
        return PrivateKeyResourceImpl.fromKey((String)"temporary BC key", (PrivateKey)privateKey, Collections.singletonList(TempPrivateKeyResourceUtil.createTempCertificate(privateKey)), (String)"BC");
    }

    private static PublicKey createTempPublicKey(final PrivateKey privateKey) {
        return new PublicKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getFormat() {
                return "X.509";
            }

            @Override
            public byte[] getEncoded() {
                return new byte[0];
            }

            @Override
            public String getAlgorithm() {
                return privateKey.getAlgorithm();
            }
        };
    }

    private static Certificate createTempCertificate(final PublicKey publicKey) {
        return new Certificate("X.509"){

            @Override
            public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            }

            @Override
            public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            }

            @Override
            public String toString() {
                return "temporary key";
            }

            @Override
            public PublicKey getPublicKey() {
                return publicKey;
            }

            @Override
            public byte[] getEncoded() throws CertificateEncodingException {
                return "TEMPORARY_CERTIFICATE_ENCODED".getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    private static Certificate createTempCertificate(PrivateKey privateKey) {
        return TempPrivateKeyResourceUtil.createTempCertificate(TempPrivateKeyResourceUtil.createTempPublicKey(privateKey));
    }
}

